/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */


#include <iostream>

#include <DaemonDM/ProfileManager.h>
#include "commontypes.h"
#include "Errors.h"

#if defined PLATFORM_WINDOWS
	//NULL;
#else
	#include <sys/param.h>
	#include <getopt.h>

	const char* const c_clSmallOptions = "hge:d:";
	const struct option LongOptions[] =
	{
		{"help",       0,      NULL,       c_clSmallOptions[0]},
		{"get",        0,      NULL,       c_clSmallOptions[1]},
		{"enable",     0,      NULL,       c_clSmallOptions[2]},
		{"disable",    0,      NULL,       c_clSmallOptions[3]},
		{NULL,         0,      NULL,       0}
	};
#endif

//------------------------------------------------------------------------------------------------------

void print_usage(FILE* stream, const char* prog_name)
{
    fprintf(stream, "Usage: %s options \n", prog_name);
    fprintf(stream,
        "   -h          --help              Display this usage information\n"
        "   -g          --get               Get information about profiles \n"
        "   -e profile  --enable profile    Set profile enable. Profile - name of profile \n"
        "   -d profile  --disable profile   Set profile disable. Profile - name of profile \n"
    );
}

//------------------------------------------------------------------------------------------------------

using namespace NS_DM_Client;

void CheckCommandLine(int argc, char** argv, ProfileManager& ui)
{

#if defined PLATFORM_WINDOWS
	//NULL;
#else
    int next_option;
    if (argc > 1)
    {
        do
        {
            next_option = getopt_long(argc, argv, c_clSmallOptions, LongOptions, 0);
            switch (next_option)
            {
                case 'h':
                {
                    print_usage(stdout, argv[0]);
                    break;
                }
                case 'g':
                {
                    ProfileInfo profile;
                    if (ui.FetchFirstProfileInfo(profile))
                    {
                        fprintf (stdout, "avialable profiles: \n");
                        fprintf (stdout, "name: %s description: %s, is enabled: %d \n", profile.m_Name, profile.m_Description, profile.m_IsEnabled);
                        ui.ReleaseProfileInfo(profile);
                        while (ui.FetchNextProfileInfo(profile) == e_Ok)
                        {
                            fprintf (stdout, "name: %s description: %s, is enabled %d \n", profile.m_Name, profile.m_Description, profile.m_IsEnabled);
                            ui.ReleaseProfileInfo(profile);
                        }
                    }
                    break;
                }
                case 'e':
                {
                    if (ui.EnableProfile(optarg, true) == e_Ok)
                    {
                        fprintf (stdout, "enable profile %s is set \n", optarg);
                    }
                    else
                    {
                        fprintf (stdout, "enable profile %s is not set \n", optarg);
                    }
                    break;
                }
                case 'd':
                {
                    if (ui.EnableProfile(optarg, false) == e_Ok)
                    {
                        fprintf (stdout, "disable profile %s is set \n", optarg);
                    }
                    else
                    {
                        fprintf (stdout, "disable profile %s is not set \n", optarg);
                    }
                    break;
                }
                default:
                {
                    fprintf (stdout, "No valid command line argument. Use -h for help\n");
                    break;
                }
            }
            // only one parameter may be in command line
            exit(EXIT_SUCCESS);
        }
        while (next_option != -1);
    }
#endif


}
//------------------------------------------------------------------------------------------------------
int main(int argc, char** argv)
{
    ProfileManager* ui = GetProfileManager();
	if (ui)
	{    
		if (ui->Init())
    	{
        	CheckCommandLine(argc, argv, *ui);
		}
		else
		{
        	fprintf (stdout, "can't Init instance of ProfileManager. Daemon not alive or some internal error \n");
		}    
        ui->Release();
	}
    else
    {
        fprintf (stdout, "can't get instance of ProfileManager \n");
    }
    return 0;
}
//------------------------------------------------------------------------------------------------------
