/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include "DeviceAdapter/IDeviceAdapter.h"
#include "DeviceAdapter/DummyDeviceAdapter.h"
#include "OMADMUserApi.h"
#include "commontypes.h"

#include <string>

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	class IWiMAXDevice;
	class IMOTreeManager;
	class IFirmwareUpdater;

	struct NetworkParameters;
	struct Contacts;
	struct RootCA;
	struct SubscriptionParameters;
	struct CAPLEntries;
	struct ChannelPlan;
	struct RAPL;
	struct OtherSubscriptions;
	struct Primary;
	struct EAP;

	class BeceemAdapter:
		public DummyDeviceAdapter
	// public IDeviceAdapter
	{
	public:
		BeceemAdapter();
		virtual ~BeceemAdapter();

		virtual bool Init(const StringMap& settings, IDaemonEngineRequest* request = 0);

		virtual bool Open();
		virtual bool Close();
		virtual void Release();

		//
		// MO tree API
		//
		virtual bool GetDeviceInfo(DevInfo& deviceInfo);
		virtual bool GetDeviceDetail(DevDetail& deviceDetail);
		virtual bool GetDMAccount(DMAcc& dmAccount);
		virtual bool GetWiMAX(WiMAX& wimax);
		virtual bool GetWiMAXSupp(WiMAXSupp& wimaxSupp);

		virtual bool SetDeviceInfo(const DevInfo& deviceInfo);
		virtual bool SetDeviceDetail(const DevDetail& deviceDetail);
		virtual bool SetDMAccount(const DMAcc& dmAccount);
		virtual bool SetWiMAX(const WiMAX& wimax);
		virtual bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp);

		//
		// Firmware update (FUMO) API
		//
		// inherit from DummyDeviceAdapter

	private:
		bool sendMessage(PUCHAR buffer, int length);
		int packMessage(void* message, USHORT type, USHORT subType, USHORT msgLength);
		int getOMADMParameterSize(OMA_DM_TREE_LEVEL* pstTestLevel, int uiLevel);
		bool getOMADMRequest(int type, USHORT subType, WIMAX_MESSAGE& requestMessage, USHORT& length);

		void copyToString(String& destination, const void* source, int size) const;

	private:
		// WiMAXSupp
		void add_NetworkParameters(NetworkParameters& dest, const ST_NetworkParameters& source);
		void add_ST_NetworkParameters(ST_NetworkParameters& dest, const NetworkParameters& source);
		void add_CALPEntries(std::vector<CAPLEntries>& dest, const ST_CAPLEntries* source, size_t size);
		void add_ST_CALPEntries(ST_CAPLEntries* dest, const std::vector<CAPLEntries>& source);
		void add_ChannelPlan(ChannelPlan& dest, const ST_ChannelPlan& source);
		void add_ST_ChannelPlan(ST_ChannelPlan& dest, const ChannelPlan& source);
		void add_RAPL(RAPL& dest, const ST_RAPL& source);
		void add_ST_RAPL(ST_RAPL& dest, const RAPL& source);

		void add_Contacts(std::vector<Contacts>& dest, const ST_Contacts* source, size_t size);
		void add_ST_Contacts(ST_Contacts* dest, const std::vector<Contacts>& source);
		void add_RootCA(std::vector<RootCA>& dest, const ST_RootCA* source, size_t size);
		void add_ST_RootCA(ST_RootCA* dest, const std::vector<RootCA>& source);
		void add_SubscriptionParameters(SubscriptionParameters& dest, const ST_SubscriptionParameters& source);
		void add_ST_SubscriptionParameters(ST_SubscriptionParameters& dest, const SubscriptionParameters& source);
		void add_OtherSubscriptions(std::vector<OtherSubscriptions>& dest,
			const ST_OtherSubscriptions* source, size_t size);
		void add_ST_OtherSubscriptions(ST_OtherSubscriptions* dest, const std::vector<OtherSubscriptions>& source);
		void add_Primary(Primary& dest, const ST_Primary& source);
		void add_ST_Primary(ST_Primary& dest, const Primary& source);
		void add_EAP(std::vector<EAP>& dest, const ST_EAP* source, size_t size);
		void add_ST_EAP(ST_EAP* dest, const std::vector<EAP>& source);

	private:
		NS_Logging::Logger& m_logger;
		void* m_deviceHandle;

	};
}
