/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "DeviceAdapter/Diagnostics/CollectDiagnosticsCommand.h"

#include "ManagementObjects/WiMAX_Diagnostics.h"
#include "daemon/ProfileComponentsHolder.h"

#include "NotifyDiagnosticsReadyCommand.h"

const char* const c_DiagnosticsLog = "Diagnostics";

namespace NS_DM_Client
{
namespace NS_DM_Diagnostics
{

CollectDiagnosticsCommand::CollectDiagnosticsCommand(ProfileComponentsHolder* prholder, int duration, 
													 const String &serverID, 
													 const String &origID)
    : m_prholder(prholder), m_duration(duration), m_serverID(serverID), m_origID(origID)
{

}

//-------------------------------------------------------------------------------------------

CollectDiagnosticsCommand::~CollectDiagnosticsCommand()
{

}

//-------------------------------------------------------------------------------------------

bool CollectDiagnosticsCommand::Execute()
{
    LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> CollectDiagnosticsCommand::Execute");

    if (!m_prholder)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: ProfileComponentsHolder not set");
        return false;
    }

    IMOTreeManager* treeManager = m_prholder->GetMOTreeManager();
    if (!treeManager)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: can't get tree manager");
        return false;
    }

    WiMAX_Diagnostics diagnostics;
    if (diagnostics.Execute())
    {
        if (diagnostics.Serialize(*treeManager))
        {
            IExecutionQueue* execQueue = m_prholder->GetExecutionQueue();
            if (!execQueue)
            {
                LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: can't get execution queue");
                return false;
            }

            NotifyDiagnosticsReadyCommand* notifyCommand = new NotifyDiagnosticsReadyCommand(m_prholder, m_serverID, m_origID);
            if (!notifyCommand)
            {
                LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: failed to create NotifyDiagnosticsReadyCommand");
                return false;
            }

            if (!execQueue->Add(*notifyCommand))
            {
                delete notifyCommand;
                LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: failed to add NotifyDiagnosticsReadyCommand to execution queue");
                return false;
            }

            LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: success");
            return true;
        }
        else
        {
            LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: failed to serialize tree");
            return false;
        }
    }
    else
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed. Reason: failed to execute diagnostic from device");
        return false;
    }

    LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << CollectDiagnosticsCommand::Execute. Status: failed");
    return false;
}

//-------------------------------------------------------------------------------------------

}
}
