/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "TestCommon.h"

#include <boost/test/unit_test.hpp>
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

#include "ManagementObjects/DevDetail.h"
#include "../../treemanager/UTestMOTree/MockDataStorage.h"

namespace fs = boost::filesystem;
using namespace NS_DM_Client;

void FillInDevDetail(DevDetail& devDetail)
{
	devDetail.m_URI.m_MaxDepth = 0;
	devDetail.m_URI.m_MaxTotLen = 0;
	devDetail.m_URI.m_MaxSegLen = 0;
	devDetail.m_DevTyp = "DevTyp";
	devDetail.m_OEM = "OEM";
	devDetail.m_FwV = "FwV";
	devDetail.m_SwV = "SwV";
	devDetail.m_HwV = "HwV";
	devDetail.m_LrgObj = true;
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeDeviceDetailInTree)
{
	NS_DM_Client::DevDetail deviceDetail;
	FillInDevDetail(deviceDetail);

	BOOST_CHECK(deviceDetail.Serialize(*S_treeManager));

	fs::path path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/DevDetail/DevTyp", fs::native);
	BOOST_CHECK(fs::exists(path));
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeDeviceDetailFromTree)
{
	NS_DM_Client::DevDetail originalDeviceDetail;
	FillInDevDetail(originalDeviceDetail);
	BOOST_CHECK(originalDeviceDetail.Serialize(*S_treeManager));

	NS_DM_Client::DevDetail newDeviceDetail;
	BOOST_CHECK(newDeviceDetail.Deserialize(*S_treeManager));

	BOOST_CHECK(newDeviceDetail.m_URI.m_MaxDepth == 0);
	BOOST_CHECK(newDeviceDetail.m_URI.m_MaxTotLen == 0);
	BOOST_CHECK(newDeviceDetail.m_URI.m_MaxSegLen == 0);
	BOOST_CHECK(newDeviceDetail.m_DevTyp == "DevTyp");
	BOOST_CHECK(newDeviceDetail.m_OEM == "OEM");
	BOOST_CHECK(newDeviceDetail.m_FwV == "FwV");
	BOOST_CHECK(newDeviceDetail.m_SwV == "SwV");
	BOOST_CHECK(newDeviceDetail.m_HwV == "HwV");
	std::cout << newDeviceDetail.m_LrgObj << std::endl;
	BOOST_CHECK(newDeviceDetail.m_LrgObj);


	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeDeviceDetailInXml)
{
	NS_DM_Client::DevDetail devDetail;
	FillInDevDetail(devDetail);

	std::string devDetailXml;
	BOOST_CHECK(devDetail.Serialize(devDetailXml));


	std::string expectedDevDetail(
		"<MgmtTree xmlns='syncml:dmddf1.2'>"
		"<VerDTD>1.2</VerDTD>\n"
		"<Node>"
		"<NodeName>MaxDepth</NodeName>\n"
		"<Path>./DevDetail/URI/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>0</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>MaxTotLen</NodeName>\n"
		"<Path>./DevDetail/URI/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>0</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>MaxSegLen</NodeName>\n"
		"<Path>./DevDetail/URI/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>0</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>DevTyp</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>DevTyp</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>OEM</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>OEM</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>FwV</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>FwV</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>SwV</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>SwV</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>HwV</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>HwV</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>LrgObj</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Format>bool</Format>\n"
		"<Value>true</Value>\n"
		"</RTProperties>"
		"</Node>"

		"</MgmtTree>"
		); 

	//std::cout << devDetailXml << std::endl << std::endl;
	// 	std::cout << expectedDevDetail << std::endl << std::endl;
	BOOST_CHECK(devDetailXml == expectedDevDetail);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeDeviceDetailFromXml)
{
	std::string devDetailXml(
		"<MgmtTree xmlns='syncml:dmddf1.2'>"
		"<VerDTD>1.2</VerDTD>\n"
		"<Node>"
		"<NodeName>MaxDepth</NodeName>\n"
		"<Path>./DevDetail/URI/</Path>\n"
		"<RTProperties>"
		"<Value>0</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>MaxTotLen</NodeName>\n"
		"<Path>./DevDetail/URI/</Path>\n"
		"<RTProperties>"
		"<Value>0</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>MaxSegLen</NodeName>\n"
		"<Path>./DevDetail/URI/</Path>\n"
		"<RTProperties>"
		"<Value>0</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>DevTyp</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Value>DevTyp</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>OEM</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Value>OEM</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>FwV</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Value>FwV</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>SwV</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Value>SwV</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>HwV</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Value>HwV</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>LrgObj</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Value>true</Value>\n"
		"</RTProperties>"
		"</Node>"

		"</MgmtTree>"
		); 


	NS_DM_Client::DevDetail devDetail;
	BOOST_CHECK(devDetail.Deserialize(devDetailXml));

	BOOST_CHECK(devDetail.m_URI.m_MaxDepth == 0);
	BOOST_CHECK(devDetail.m_URI.m_MaxTotLen == 0);
	BOOST_CHECK(devDetail.m_URI.m_MaxSegLen == 0);
	BOOST_CHECK(devDetail.m_DevTyp == "DevTyp");
	BOOST_CHECK(devDetail.m_OEM == "OEM");
	BOOST_CHECK(devDetail.m_FwV == "FwV");
	BOOST_CHECK(devDetail.m_SwV == "SwV");
	BOOST_CHECK(devDetail.m_HwV == "HwV");
	BOOST_CHECK(devDetail.m_LrgObj == true);
}
//-------------------------------------------------------------------------------------------

