/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "TestCommon.h"

#include <boost/test/unit_test.hpp>
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

#include "ManagementObjects/DevDetail.h"
#include "../../treemanager/UTestMOTree/MockDataStorage.h"
#include "ManagementObjects/DevInfo.h"

namespace fs = boost::filesystem;
using namespace NS_DM_Client;

void FillInDevInfo(DevInfo& devInfo)
{
	devInfo.m_DevId = "DevId";
	devInfo.m_Man = "Man";
	devInfo.m_Mod = "Mod";
	devInfo.m_DmV = "DmV";
	devInfo.m_Lang = "Lang";
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeDeviceInfoInTree)
{
	NS_DM_Client::DevInfo deviceInfo;
	FillInDevInfo(deviceInfo);

	BOOST_CHECK(deviceInfo.Serialize(*S_treeManager));

	fs::path path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/DevInfo/Lang", fs::native);
	BOOST_CHECK(fs::exists(path));
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeDeviceInfoFromTree)
{
	NS_DM_Client::DevInfo originalDeviceInfo;
	FillInDevInfo(originalDeviceInfo);
	BOOST_CHECK(originalDeviceInfo.Serialize(*S_treeManager));

	NS_DM_Client::DevInfo newDevInfo;
	BOOST_CHECK(newDevInfo.Deserialize(*S_treeManager));
	BOOST_CHECK(newDevInfo.m_DevId == "DevId");
	BOOST_CHECK(newDevInfo.m_Man == "Man");
	BOOST_CHECK(newDevInfo.m_Mod == "Mod");
	BOOST_CHECK(newDevInfo.m_DmV == "DmV");
	BOOST_CHECK(newDevInfo.m_Lang == "Lang");


	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeDeviceInfoFromTreeWithEmptySubTree)
{
	NS_DM_Client::DevInfo originalDeviceInfo;
	BOOST_CHECK(originalDeviceInfo.Serialize(*S_treeManager));

	NS_DM_Client::DevInfo newDevInfo;
	BOOST_CHECK(newDevInfo.Deserialize(*S_treeManager));

	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeDeviceInfoInXml)
{
	NS_DM_Client::DevInfo deviceInfo;
	deviceInfo.m_DevId = "DevId";
	deviceInfo.m_Man = "Man";
	deviceInfo.m_Mod = "Mod";
	deviceInfo.m_DmV = "DmV";
	deviceInfo.m_Lang = "Lang";
	std::string deviceInfoXml;
	BOOST_CHECK(deviceInfo.Serialize(deviceInfoXml));

	std::string expectedDeviceInfo(
		"<MgmtTree xmlns='syncml:dmddf1.2'>"
		"<VerDTD>1.2</VerDTD>\n"
		"<Node>"
		"<NodeName>DevId</NodeName>\n"
		"<Path>./DevInfo/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>DevId</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>Man</NodeName>\n"
		"<Path>./DevInfo/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>Man</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>Mod</NodeName>\n"
		"<Path>./DevInfo/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>Mod</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>DmV</NodeName>\n"
		"<Path>./DevInfo/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>DmV</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>Lang</NodeName>\n"
		"<Path>./DevInfo/</Path>\n"
		"<RTProperties>"
		"<Format>chr</Format>\n"
		"<Value>Lang</Value>\n"
		"</RTProperties>"
		"</Node>"

		"</MgmtTree>"
		); 

	// 	std::cout << deviceInfoXml << std::endl << std::endl;
	// 	std::cout << expectedDeviceInfo << std::endl << std::endl;
	BOOST_CHECK(deviceInfoXml == expectedDeviceInfo);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeDeviceInfoFromXml)
{
	std::string deviceInfoXml(
		"<MgmtTree xmlns='syncml:dmddf1.2'>"
		"<VerDTD>1.2</VerDTD>\n"
		"<Node>"
		"<NodeName>DevId</NodeName>\n"
		"<Path>./DevInfo/</Path>\n"
		"<RTProperties>"
		"<Value>DevId</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>Man</NodeName>\n"
		"<Path>./DevInfo/</Path>\n"
		"<RTProperties>"
		"<Value>Man</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>Mod</NodeName>\n"
		"<Path>./DevInfo/</Path>\n"
		"<RTProperties>"
		"<Value>Mod</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>DmV</NodeName>\n"
		"<Path>./DevInfo/</Path>\n"
		"<RTProperties>"
		"<Value>DmV</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>Lang</NodeName>\n"
		"<Path>./DevInfo/</Path>\n"
		"<RTProperties>"
		"<Value>Lang</Value>\n"
		"</RTProperties>"
		"</Node>"

		"</MgmtTree>"
		); 

	NS_DM_Client::DevInfo deviceInfo;
	BOOST_CHECK(deviceInfo.Deserialize(deviceInfoXml));

	BOOST_CHECK(deviceInfo.m_DevId == "DevId");
	BOOST_CHECK(deviceInfo.m_Man == "Man");
	BOOST_CHECK(deviceInfo.m_Mod == "Mod");
	BOOST_CHECK(deviceInfo.m_DmV == "DmV");
	BOOST_CHECK(deviceInfo.m_Lang == "Lang");
}
//-------------------------------------------------------------------------------------------

