/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "../stdafx.h"
#include "FStream.h"
#include <windows.h>
#include <Psapi.h>

static const size_t INFO_BUFFER_SIZE  = 265;

namespace NS_Logging
{
	static const std::string S_logFilePath("%ALLUSERSPROFILE%/Funambol/DMClient/Logs/");
	static const std::string S_commonLogFile("_OMA_DM_Client.log");
	static const std::string S_slash("_");
	static const std::string S_ext(".log");

	std::string GetCurrentProcessName()
	{
		HANDLE curProcess = ::GetCurrentProcess();
		char processName[INFO_BUFFER_SIZE] = {0}; 
		DWORD res = ::GetModuleBaseNameA(curProcess, 0, processName, INFO_BUFFER_SIZE);
		if (res == 0)
			return S_commonLogFile;

		return processName;
	}
	//-------------------------------------------------------------------------------------------

	IOutStream* CreateStream(const char* name)
	{
		FStream* stream = new FStream(name);
		char  buf[INFO_BUFFER_SIZE];
		// MSDN: When using ANSI strings, the buffer size should be the string length, plus terminating null character, plus one.
		::ExpandEnvironmentStringsA(S_logFilePath.c_str(), buf, INFO_BUFFER_SIZE - 2);
		std::string logFilePath = buf;

		int processID = ::GetCurrentProcessId();
		const int maxSize = 1024;
		char buffer[maxSize] = {0};
		_itoa(processID, buffer, 10);
		std::string processName = GetCurrentProcessName();

		stream->Open((logFilePath + processName + S_slash + buffer + S_ext).c_str());
		//stream->Open((logFilePath + std::string(name) + ".txt").c_str());
		return stream;
	}
}