/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */


#include "CurlDownloader.h"

#define HTTP_OK 200
#define HTTP_NOT_FOUND 404

using namespace NS_DM_Client::NS_Common;


CurlDownloader::CurlDownloader(const char *URL) : Downloader(URL)
{
	context = curl_easy_init();
	if (context)
	{
		m_error = curl_easy_setopt(context, CURLOPT_USERAGENT, "Funambol DM Client");
	}
	else
	{
		m_error = CURLE_FAILED_INIT;
	}
}


CurlDownloader::~CurlDownloader()
{
    if (context)
        curl_easy_cleanup(context);
}


Downloader::DownloadStatus CurlDownloader::Download()
{
	if (!context)
	{
        return DS_NOT_INITIALIZED;
    }

	if ((m_error = curl_easy_setopt(context, CURLOPT_URL, m_url)) ||
		(m_error = curl_easy_setopt(context, CURLOPT_WRITEFUNCTION, &writeDataCallback)) ||
		(m_error = curl_easy_setopt(context, CURLOPT_WRITEDATA, this)) ||
		(m_error = curl_easy_setopt(context, CURLOPT_HEADERFUNCTION, responseHeader)) ||
        (m_error = curl_easy_setopt(context, CURLOPT_WRITEHEADER, this)) ||
		(m_error = curl_easy_perform(context))
		)
	{
		// finalize
		// what ???
		long res_code = 0;
		if (CURLE_OK == curl_easy_getinfo(context, CURLINFO_RESPONSE_CODE, &res_code))
		{
			m_error = res_code;
		}
		return DS_FAILED;
	}
	else
	{
		// all exited with CURLE_OK = 0
		long res_code = 0;
		if (CURLE_OK == curl_easy_getinfo(context, CURLINFO_RESPONSE_CODE, &res_code))
		{
			m_error = res_code;
			if (HTTP_OK != res_code)
				return DS_MALFORMED_URL;
		}
		return DS_FINISHED;
	}
}


size_t CurlDownloader::responseHeader(void *buffer, size_t size, size_t nmemb, void *stream)
{
    CurlDownloader *downloader = (CurlDownloader*)stream;
    size_t curr = size * nmemb;

	char cbf[256] = {0};
	if (curr < 256) {
		memcpy(cbf, buffer, curr);

		// find HTTP property with ':' as a delimiter
		const char *propName  = strtok(cbf, ":");
		const char *value = strtok(NULL, ":");
		const int   valsize = value ? strlen(value) : 0;
		char *propValue = NULL;

		if (value && valsize) {
			int len=0;
			bool skipchars = true;
			propValue = new char[valsize+1];
			// skip first blank space ' ' and trailings \r\n
			while (*value != '\r' && *value != '\n' && *value != '\0' && len <= valsize) {
				skipchars = skipchars && (' ' == *value);
				if (skipchars) {
					value++;
					continue;
				}

				propValue[len] = *value;
				value++;
				len++;
			}
			propValue[len] = 0;
		}

		if (propName && propValue)
			downloader->setProperty(propName, propValue);
		
		if (propValue)
			delete [] propValue;
	}
    return curr;
}


size_t CurlDownloader::writeDataCallback(void *ptr, size_t size, size_t nmemb, void *stream)
{
	CurlDownloader *downloader = (CurlDownloader*)stream;

	// if 0 is returned, curl will break downloading
	return downloader->storeBuffer(ptr, size*nmemb);
}

