/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "DynamicLoader.h"
#include <dlfcn.h>

using namespace NS_DM_Client;

DynamicLoader::DynamicLoader()
: m_handle(0)
{

}


DynamicLoader::~DynamicLoader()
{
    if (m_handle)
    {
        Unload();
    }

}


void* DynamicLoader::Load(const char* lib, const char* method, long param)
{
    if (m_handle)
    {
        return 0;
    }

    void* resource = 0;
    const char* error = 0;
    /* Open the shared object */
    LIBHANDLE dl_handle = dlopen( lib, RTLD_NOW );
    if (dl_handle)
    {
        /* Resolve the symbol (method) from the object */
        CREATE_FUNC func = (CREATE_FUNC)dlsym( dl_handle, method );
        if (func)
        {
            resource = (*func)(param);
            m_handle = dl_handle;
        }
        else
        {
            error = dlerror();
            dlclose(dl_handle);
        }

    }

    error = dlerror();
    m_error = (error) ? error : "";

    return resource;
}


void DynamicLoader::Unload()
{
    dlclose(m_handle);
    m_handle = 0;
}


const char* DynamicLoader::GetLoadErrorDescription() const
{
	return m_error.c_str();
}
