/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "daemon/NotificationCenter.h"
#include "lock.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Common;

NotificationCenter::NotificationCenter()
{
	Lock guard(m_notifsGuard);
}


NotificationCenter::~NotificationCenter()
{
	Lock guard(m_notifsGuard);
}


bool NotificationCenter::exists(INotification* notif)
{
	Notifications::iterator iExist = m_notifs.find(notif);
	return (iExist != m_notifs.end());
}


bool NotificationCenter::Subscribe(INotification* notif)
{
	Lock guard(m_notifsGuard);

	bool brc = false;
	if (notif && !exists(notif))
	{
		m_notifs[notif] = notif;
		brc = exists(notif);
	}

	return brc;
}


bool NotificationCenter::Unsubscribe(INotification* notif)
{
	Lock guard(m_notifsGuard);

	bool brc = false;
	if (notif)
	{
		Notifications::iterator iExist = m_notifs.find(notif);
		if (iExist != m_notifs.end())
		{
			m_notifs.erase(iExist);
			brc = !exists(notif);
		}
	}

	return brc;
}


void NotificationCenter::SessionStarted(bool isSuccessful)
{
	Lock guard(m_notifsGuard);

	for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
		i != iend; ++i)
	{
		i->second->SessionStarted(isSuccessful);
	}
}


void NotificationCenter::SessionAborted()
{
	Lock guard(m_notifsGuard);

	for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
		i != iend; ++i)
	{
		i->second->SessionAborted();
	}
}


void NotificationCenter::SessionFinished()
{
	Lock guard(m_notifsGuard);

	for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
		i != iend; ++i)
	{
		i->second->SessionFinished();
	}
}


void NotificationCenter::CheckFirmwareUpdateStatus(bool isNewFirmware)
{
	Lock guard(m_notifsGuard);

	for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
		i != iend; ++i)
	{
		i->second->CheckFirmwareUpdateStatus(isNewFirmware);
	}
}


void NotificationCenter::StartDMSessionStatus(bool started)
{
	Lock guard(m_notifsGuard);

	for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
		i != iend; ++i)
	{
		i->second->StartDMSessionStatus(started);
	}
}


void NotificationCenter::FirmwareUpdateStart(FirmwareUpdate::EnumFirmwareOperation fwo)
{
	Lock guard(m_notifsGuard);

	for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
		i != iend; ++i)
	{
		i->second->FirmwareUpdateStart(fwo);
	}
}


void NotificationCenter::FirmwareUpdateFinished(FirmwareUpdate::EnumFirmwareOperation fwo)
{
	Lock guard(m_notifsGuard);

	for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
		i != iend; ++i)
	{
		i->second->FirmwareUpdateFinished(fwo);
	}
}


void NotificationCenter::StartDRMDCollecting(int duration)
{
	Lock guard(m_notifsGuard);

	for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
		i != iend; ++i)
	{
		i->second->StartDRMDCollecting(duration);
	}
}
