/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "daemon/ProfileComponentsHolder.h"
#include "DataStorage/IDataStorage.h"
#include "treemanager/IMOTreeManager.h"
#include "serverexchange/IServerExchangeManager.h"
#include "executionqueue/IExecutionQueue.h"
#include "DeviceAdapter/IDeviceAdapter.h"
#include "NotificationListener/INotificationListener.h"
#include "daemon/INotificationCenter.h"
#include "daemon/IDaemonEngineRequest.h"

// Dynamic Library loading API
#include "DynamicLoader.h"

#include <cstdio>

using namespace NS_DM_Client;

template<typename _Ty>
void Release(_Ty*& o)
{
    if (o)
    {
	    o->Release();
	    o = NULL;
    }
}

template<typename _Ty>
void Delete(_Ty*& o)
{
    if (o)
    {
	    delete o;
	    o = NULL;
    }
}


ProfileComponentsHolder::ProfileComponentsHolder(void)
:m_ExecQueue(NULL),
m_ServExchange(NULL),
m_MOTree(NULL),
m_NotificationListener(NULL),
m_DataStorage(NULL),
m_DeviceAdapter(NULL),
m_DeviceAdapterDynamicLoader(NULL),
m_NotificationCenter(NULL),
m_daemonEngineRequest(NULL)
{
}


ProfileComponentsHolder::~ProfileComponentsHolder(void)
{
	Release(m_DataStorage);

    Delete(m_NotificationListener);
    Delete(m_ServExchange);
    Delete(m_MOTree);
	SetDeviceAdapter(NULL);
    Delete(m_ExecQueue);

	SetNotificationCenter(NULL);
    // TODO !!! Delete objects
}


IExecutionQueue*		ProfileComponentsHolder::GetExecutionQueue()
{
	return m_ExecQueue;
}


IServerExchangeManager*	ProfileComponentsHolder::GetServerExchangeManager()
{
	return m_ServExchange;
}


IMOTreeManager*			ProfileComponentsHolder::GetMOTreeManager()
{
	return m_MOTree;
}

INotificationListener*	ProfileComponentsHolder::GetNotificationListener()
{
	return m_NotificationListener;
}


IDataStorage*			ProfileComponentsHolder::GetDataStorage()
{
	return m_DataStorage;
}


IDeviceAdapter*			ProfileComponentsHolder::GetDeviceAdapter()
{
	return m_DeviceAdapter;
}

INotificationCenter*			ProfileComponentsHolder::GetNotificationCenter()
{
	return m_NotificationCenter;
}

IDaemonEngineRequest*	ProfileComponentsHolder::GetDaemonEngineRequest()
{
	return m_daemonEngineRequest;
}


void	ProfileComponentsHolder::SetExecutionQueue(IExecutionQueue* execq)
{
    Delete(m_ExecQueue);
	m_ExecQueue = execq;
}


void	ProfileComponentsHolder::SetServerExchangeManager(IServerExchangeManager* sxm)
{
    Delete(m_ServExchange);
	m_ServExchange = sxm;
}


void	ProfileComponentsHolder::SetMOTreeManager(IMOTreeManager* motm)
{
    Delete(m_MOTree);
	m_MOTree = motm;
}


void	ProfileComponentsHolder::SetNotificationListener(INotificationListener* nl)
{
    Delete(m_NotificationListener);
	m_NotificationListener = nl;
}


void	ProfileComponentsHolder::SetDataStorage(IDataStorage* ds)
{
	Release(m_DataStorage);
	m_DataStorage = ds;
}


void	ProfileComponentsHolder::SetDeviceAdapter(IDeviceAdapter* da, DynamicLoader* dl)
{
	Release(m_DeviceAdapter);
	m_DeviceAdapter = da;

//	TODO delete liblary loader
//    Delete(m_DeviceAdapterDynamicLoader);
	m_DeviceAdapterDynamicLoader = dl;
	Delete(m_daemonEngineRequest);
}

void	ProfileComponentsHolder::SetNotificationCenter(INotificationCenter* nc)
{
	Delete(m_NotificationCenter);
	m_NotificationCenter = nc;
}

void	ProfileComponentsHolder::SetDaemonEngineRequest(IDaemonEngineRequest* der)
{
	Delete(m_daemonEngineRequest);
	m_daemonEngineRequest = der;
}

