/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "executionqueue/CommandInvokeThread.h"
#include "executionqueue/ICommand.h"
#include "Event.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_ExecutionQueue;
using namespace NS_DM_Client::NS_Common;

CommandInvokeThread::CommandInvokeThread(
    EventEx&      resEvent,
    CommandsQueue&  cmdsQ,
    NS_Logging::Logger& logger
):
	m_resumeEvent(resEvent),
	m_cmdsQ(cmdsQ),
	m_logger(logger)
{
	terminate = false;
}


CommandInvokeThread::~CommandInvokeThread(void)
{
}


void CommandInvokeThread::run()
{
    LOG_DEBUG_(m_logger, "CommandInvokeThread::run (%p) started with CmdsQ (%p). ", this, &m_cmdsQ);

    while(!terminate)
    {
        EnumResumeReason resumeReason = static_cast<EnumResumeReason>(m_resumeEvent.wait());
        if (resumeReason == e_Stop)
        {
			LOG_DEBUG_(m_logger, "CommandInvokeThread::run STOP signal. ");
            break;
        }

        if (resumeReason == e_NewCommand)
        {
			LOG_DEBUG_(m_logger, "CommandInvokeThread::run NEWCOMMAND signal. ");
            ICommand* cmd = NULL;
            while (!terminate && (cmd = m_cmdsQ.popCommand()) != 0)
            {
				LOG_DEBUG_(m_logger, "Command (%p) started. ", cmd);
                bool cmdRes = cmd->Execute();
				LOG_DEBUG_(m_logger, "Command (%p) finished with result=%d. ", cmd, cmdRes);
                delete cmd;
            }
        }
    }
	terminate = false;

    LOG_DEBUG_(m_logger, "CommandInvokeThread::run (%p) finished. ", this);
}


void CommandInvokeThread::softTerminate()
{
    LOG_DEBUG_(m_logger, "CommandInvokeThread: issue STOP signal. ");
    FThread::softTerminate();
    m_resumeEvent.signal(e_Stop);
}
