/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include <vector>
#include "Logger/LoggerMacroses.h"
#include "serverexchange/CommandStorage.h"
#include "serverexchange/wrappers/SCommandAdapter.h"
#include "serverexchange/wrappers/SResponseCommand.h"


using namespace NS_DM_Client::NS_SyncMLCommand;
using namespace NS_DM_Client::NS_Common;

const char * s_cStorage = "CommandStorage";

CommandStorage::CommandStorage()
{
}


CommandStorage::~CommandStorage()
{
}


void CommandStorage::Add(SCommandPtr ptrCommand)
{
	m_commands.push_back(ptrCommand);
}


void CommandStorage::Clear()
{
	m_commands.clear();
}


void CommandStorage::InsertFirst(SCommandPtr ptrCommand)
{
	m_commands.insert(m_commands.begin(), ptrCommand);
}


void CommandStorage::Remove(const char * msgid, const char * cmdid, const char *cmdname)
{
	if (m_commands.empty() || !msgid || !cmdid || !cmdname) return;

	SCommands::iterator it = m_commands.begin();
	SCommands  newlist;

	while (it != m_commands.end())
	{
		SCommandPtr &cmd = *it;
		if (cmd.get() ||
			(cmd->GetMessageID() && strcmp(msgid, cmd->GetMessageID())) ||
		    (cmd->GetCmdID() && strcmp(cmdid, cmd->GetCmdID()))
		    )
		{
			SResponseCommand *pResponse = dynamic_cast<SResponseCommand*>(cmd.get());
			if (pResponse)
			{
				if (pResponse->GetCmdRef() && strcmp(cmdname, pResponse->GetCmdRef()))
					newlist.push_back(*it);
			}
			else
				newlist.push_back(*it);
		}
		++it;
	}

	if (newlist.size() != m_commands.size())
		m_commands = newlist;
}


int CommandStorage::Size()
{
	return m_commands.size();
}


SCommandPtr CommandStorage::operator[] (unsigned int index)
{
	if (m_commands.size() && index < m_commands.size() && index >= 0)
	{
		return m_commands[index];
	}
	else
	{
		return NS_SyncMLCommand::SCommandPtr();
	}
}

//// 2011.05.11
bool CommandStorage::Lock()
{
	m_sc.Lock();
	return true;
}

int  CommandStorage::TryLock()
{
	return m_sc.TryLock();
}

void CommandStorage::Unlock()
{
	m_sc.Unlock();
}
