/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "executionqueue/IExecutionQueue.h"
#include "serverexchange/commands/HandleNetworkEntryCommand.h"
#include "serverexchange/commands/SEMNetworkEntranceCommand.h"
#include "serverexchange/IServerExchangeManager.h"
#include "treemanager/IMOTreeManager.h"

#include "Logger/LoggerMacroses.h"

#include "Utils.h"

using namespace NS_DM_Client;


HandleNetworkEntryCommand::HandleNetworkEntryCommand(ProfileComponentsHolder& pch, int homeNspID, const char* operatorName)
:
m_pch(pch),
m_homeNspID(homeNspID)
{
	if (operatorName)
	{
		m_operatorName = operatorName;
	}
}


HandleNetworkEntryCommand::~HandleNetworkEntryCommand()
{
}


bool HandleNetworkEntryCommand::Execute()
{
	bool startWIB = false;
	bool result = triggerWIB(startWIB);
	
	SEMNetworkEntranceCommand *cmd = new SEMNetworkEntranceCommand(m_pch, m_homeNspID, m_operatorName.c_str(), startWIB);
	if (!m_pch.GetExecutionQueue()->Add(*cmd))
	{
//		LOG_ERROR_(m_logger, "Failed to add command %p to Q", cmd);
		delete cmd;
		cmd = NULL;
		result = false;
	}

	return result;
}


bool HandleNetworkEntryCommand::triggerWIB(bool& startWIB)
{
	// command checks if WIB should be triggered
	// and starts WIB (submits appropriate command)
	IMOTreeManager* treeManager = m_pch.GetMOTreeManager();
	if (!treeManager)
	{
		// command failed to execute
		return false;
	}

	bool result = true;
	String operatorURI = "./WiMAXSupp/Operator";

	String idHomeNSP = ToString(m_homeNspID);
	IMOTreeManager::ChildrenPaths children;
	if (treeManager->GetChildren(operatorURI, children) == e_Ok)
	{
		bool homeNspIDFound = false;
		String homeNSP;
		homeNSP.reserve(128);
		for (unsigned i = 0; !homeNspIDFound && i < children.size(); ++i)
		{
			homeNSP = operatorURI;
			homeNSP += "/";
			homeNSP += children[i].c_str();
			homeNSP += "/NetworkParameters/H-NSP";

			IMOTreeManager::ChildrenPaths childrenHNSP;
			if (treeManager->GetChildren(homeNSP, childrenHNSP) == e_Ok)
			{
				String nodeValue;
				String homeNSPIdUri;
				homeNSPIdUri.reserve(128);
				for (unsigned j = 0; j < childrenHNSP.size(); ++j)
				{
					homeNSPIdUri = homeNSP;
					homeNSPIdUri += "/";
					homeNSPIdUri +=	childrenHNSP[j].c_str();
					homeNSPIdUri += "/H-NSP-ID";
					if (treeManager->GetValue(homeNSPIdUri, nodeValue) == e_Ok)
					{
						if (nodeValue == idHomeNSP)
						{
							homeNspIDFound = true;
							break;
						}
					}
				}
			}
		}

		if (!homeNspIDFound)
		{
			startWIB = true;
		}
	}

	return result;
}


