/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include "commontypes.h"

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	namespace NS_DataStorage
	{
		class IDataStorage;
	}
}

namespace NS_DM_Client
{
    extern const char* S_seperator;
    extern const char* S_rootNode;
    extern const char* S_interiorNode;
    extern const char* S_permanentFile;

	extern const char* S_propertyName[];

	enum Property
	{
		e_ACL,
		e_format,
		e_name,
		e_size,
		e_title,
		e_tstamp,
		e_type,
		e_verNo
	};

	class Node
	{
	public:
		Node(const URI& path, NS_DM_Client::NS_DataStorage::IDataStorage* dataStorage);
		~Node();

		void SetContent(const String& content);
		bool GetContent(String& content) const;

		void SetProperty(Property name, const String& value);
		bool GetProperty(Property name, String& content) const;

        Node* GetParent() const;
        Node* GetExistingParent() const;

        bool IsPermanent() const;
        void SetPermanent();

		bool IsLeaf() const;
		bool Exist() const;
		bool Delete();

		typedef std::vector<URI> ChildrenPaths;
		bool GetChildren(ChildrenPaths& children) const;
		const URI& GetPath() const { return m_path; }
		const URI GetName() const;
		bool GetContentSize(size_t& size) const;

	private:
		void copyFromBuffer(String& destination, void* source, size_t size) const;

	private:
		String m_path;
		NS_DM_Client::NS_DataStorage::IDataStorage* m_dataStorage;
		NS_Logging::Logger& m_logger;
	};

	bool GetPropertyByName(const String& name, Property& property);
	bool IsPropertyReplacementSupported(Property property);
    void ParseNodePath(const URI& full_name, String& path_name, String& node_name);
    Node* GetExistingParentWithACL(const Node* node);
	String IntToString(int value);
}
