/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#pragma once

#include "DeviceAdapter/IDeviceAdapter.h"

namespace NS_DM_Client
{

	class MockDeviceAdapter : public IDeviceAdapter
	{
	public:
		bool Init(const StringMap& settings, IDaemonEngineRequest* request = 0)
		{
			return true;
		}

		bool Open()
		{
			return true;
		}

		bool Close()
		{
			return true;
		}

		void Release()
		{
			delete this;
		}

		bool GetDeviceInfo(DevInfo& deviceInfo)
		{
			return true;
		}

		bool GetDeviceDetail(DevDetail& deviceDetail)
		{
			return true;
		}

		bool GetDMAccount(DMAcc& dmAccount)
		{
			return true;
		}

		bool GetWiMAX(WiMAX& wimax)
		{
			return true;
		}

		bool GetWiMAXSupp(WiMAXSupp& wimaxSupp)
		{
			return true;
		}

		bool SetDeviceInfo(const DevInfo& deviceInfo)
		{
			return true;
		}

		bool SetDeviceDetail(const DevDetail& deviceDetail)
		{
			return true;
		}

		bool SetDMAccount(const DMAcc& dmAccount)
		{
			return true;
		}

		bool SetWiMAX(const WiMAX& wimax)
		{
			return true;
		}

		bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp)
		{
			return true;
		}

		EnumFirmwareStatus InitFirmwareStorage(const char* packageName = 0, const char* location = 0)
		{
			return IFirmwareUpdater::e_OK;
		}

		EnumFirmwareStatus ResetFirmwareStorage()
		{
			return IFirmwareUpdater::e_OK;
		}

		EnumFirmwareStatus AppendFirmwareChunk(const char* buffer, size_t size, bool last)
		{
			return IFirmwareUpdater::e_OK;
		}

		EnumFirmwareStatus UpdateFirmware()
		{
			return IFirmwareUpdater::e_OK;
		}

		bool GetEMSK(void*, size_t& size)
		{
			return false;
		}

		bool SetEMSK(const void*, size_t size)
		{
			return false;
		}

		bool SetDeviceID(const void*, size_t size)
		{
			return false;
		}

		bool GetDeviceID(void*, size_t& size)
		{
			return false;
		}

		bool GetNetworkInterfaceName(char*, size_t& size)
		{
			return false;
		}

	};
	//-------------------------------------------------------------------------------------------
}
