/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

//#include <boost/test/unit_test.hpp>
//#include "boost/filesystem/operations.hpp"
//#include "boost/filesystem/path.hpp"
//
//#include "../Node.h"
//#include <iostream>
//#include "treemanager/MOTreeManager.h"
//#include "MockDataStorage.h"
//#include <syncml/core/Item.h>
//#include "Common.h"
//#include "Errors.h"
//
////const std::string S_root;
////const std::string S_workingDirectory("MockMOTree");
//
//namespace fs = boost::filesystem;
//
//BOOST_AUTO_TEST_CASE(AddNodeAndRollback)
//{
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
// 	Funambol::Item newItem;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	newItem.setMeta(&meta);
// 	newItem.setData(&Funambol::ComplexData("some value"));
//
// 	BOOST_CHECK(S_treeManager.Add("AddNodeAndRollback/Root/InteriorSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Add("AddNodeAndRollback/Root/InteriorSubNode/LeafNode2", newItem) == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Rollback() == NS_DM_Client::e_Ok);
//	BOOST_CHECK(S_treeManager.Get("AddNodeAndRollback/Root/InteriorSubNode/LeafNode1", newItem) == NS_DM_Client::e_NotFound);
//	BOOST_CHECK(S_treeManager.Get("AddNodeAndRollback/Root/InteriorSubNode/LeafNode2", newItem) == NS_DM_Client::e_NotFound);
//
//	fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/AddNodeAndRollback");
//}
//
//BOOST_AUTO_TEST_CASE(AddNodeAndCommit)
//{
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
// 	Funambol::Item newItem;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	newItem.setMeta(&meta);
// 	newItem.setData(&Funambol::ComplexData("some value"));
//
// 	BOOST_CHECK(S_treeManager.Add("AddNodeAndCommit/Root/InteriorSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Add("AddNodeAndCommit/Root/InteriorSubNode/LeafNode2", newItem) == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Commit() == NS_DM_Client::e_Ok);
//	BOOST_CHECK(S_treeManager.Get("AddNodeAndCommit/Root/InteriorSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
//	BOOST_CHECK(S_treeManager.Get("AddNodeAndCommit/Root/InteriorSubNode/LeafNode2", newItem) == NS_DM_Client::e_Ok);
//
//	fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/AddNodeAndCommit");
//}
//
//BOOST_AUTO_TEST_CASE(AddSeparateNodeAndStartTransactionAndAddNodeAndRollback)
//{
//
// 	Funambol::Item newItem;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	newItem.setMeta(&meta);
// 	newItem.setData(&Funambol::ComplexData("some value"));
//
// 	BOOST_CHECK(S_treeManager.Add("AddSeparateNodeAndStartTransactionAndAddNodeAndRollback/Root/InteriorSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Add("AddSeparateNodeAndStartTransactionAndAddNodeAndRollback/Root/InteriorSubNode/LeafNode2", newItem) == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Rollback() == NS_DM_Client::e_Ok);
//	BOOST_CHECK(S_treeManager.Get("AddSeparateNodeAndStartTransactionAndAddNodeAndRollback/Root/InteriorSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
//	BOOST_CHECK(S_treeManager.Get("AddSeparateNodeAndStartTransactionAndAddNodeAndRollback/Root/InteriorSubNode/LeafNode2", newItem) == NS_DM_Client::e_NotFound);
//
//	fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/AddSeparateNodeAndStartTransactionAndAddNodeAndRollback");
//}
//
//BOOST_AUTO_TEST_CASE(AddSeparateNodeAndStartTransactionAndAddNodeAndCommit)
//{
// 	Funambol::Item newItem;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	newItem.setMeta(&meta);
// 	newItem.setData(&Funambol::ComplexData("some value"));
//
// 	BOOST_CHECK(S_treeManager.Add("AddSeparateNodeAndStartTransactionAndAddNodeAndCommit/Root/InteriorSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Add("AddSeparateNodeAndStartTransactionAndAddNodeAndCommit/Root/InteriorSubNode/LeafNode2", newItem) == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Commit() == NS_DM_Client::e_Ok);
//	BOOST_CHECK(S_treeManager.Get("AddSeparateNodeAndStartTransactionAndAddNodeAndCommit/Root/InteriorSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
//	BOOST_CHECK(S_treeManager.Get("AddSeparateNodeAndStartTransactionAndAddNodeAndCommit/Root/InteriorSubNode/LeafNode2", newItem) == NS_DM_Client::e_Ok);
//
//	fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/AddSeparateNodeAndStartTransactionAndAddNodeAndCommit");
//}
//
//BOOST_AUTO_TEST_CASE(DeleteLeafNodeAndRollback)
//{
// 	Funambol::Item newItem;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	newItem.setMeta(&meta);
// 	newItem.setData(&Funambol::ComplexData("some value"));
//
// 	BOOST_CHECK(S_treeManager.Add("DeleteLeafNodeAndRollback/Root/InteriorSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Delete("DeleteLeafNodeAndRollback/Root/InteriorSubNode/LeafNode1") == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Rollback() == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(S_treeManager.Get("DeleteLeafNodeAndRollback/Root/InteriorSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
//
//	fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/DeleteLeafNodeAndRollback");
//}
//
//BOOST_AUTO_TEST_CASE(DeleteParentNodeWithChildsAndRollback)
//{
// 	Funambol::Item newItem;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	newItem.setMeta(&meta);
// 	newItem.setData(&Funambol::ComplexData("some value"));
//
// 	BOOST_CHECK(S_treeManager.Add("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode1/LeafNode1", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Add("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode1/LeafNode2", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Add("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode2/LeafNode1", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Add("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode2/LeafNode2", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Add("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode2/InteriorSubSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Add("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode2/InteriorSubSubNode/LeafNode2", newItem) == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Delete("DeleteParentNodeWithChildsAndRollback/Root") == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Rollback() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Get("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode1/LeafNode1", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Get("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode1/LeafNode2", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Get("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode2/LeafNode1", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Get("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode2/LeafNode2", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Get("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode2/InteriorSubSubNode/LeafNode1", newItem) == NS_DM_Client::e_Ok);
// 	BOOST_CHECK(S_treeManager.Get("DeleteParentNodeWithChildsAndRollback/Root/InteriorSubNode2/InteriorSubSubNode/LeafNode2", newItem) == NS_DM_Client::e_Ok);
//
//    fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/DeleteParentNodeWithChildsAndRollback");
//}
//
//BOOST_AUTO_TEST_CASE(ReplaceNodeValueAndRollback)
//{
// 	Funambol::Item Item;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	Item.setMeta(&meta);
// 	Item.setData(&Funambol::ComplexData("original value"));
//
// 	BOOST_CHECK(S_treeManager.Add("ReplaceNodeValueAndRollback/Root/InteriorSubNode1/LeafNode1", Item) == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
//    Funambol::ComplexData new_data("replaced value");
//    Item.setData(&new_data);
//
// 	BOOST_CHECK(S_treeManager.Replace("ReplaceNodeValueAndRollback/Root/InteriorSubNode1/LeafNode1", Item) == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Rollback() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Get("ReplaceNodeValueAndRollback/Root/InteriorSubNode1/LeafNode1", Item) == NS_DM_Client::e_Ok);
//
//    NS_DM_Client::String val = Item.getData()->getData();
// 	BOOST_CHECK(val.compare("original value") == 0);
//
//    fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/ReplaceNodeValueAndRollback");
//}
//
//BOOST_AUTO_TEST_CASE(ReplacePropertyValueAndRollback)
//{
// 	Funambol::Item Item;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	Item.setMeta(&meta);
// 	Item.setData(&Funambol::ComplexData("some data"));
//
// 	BOOST_CHECK(S_treeManager.Add("ReplacePropertyValueAndRollback/Root/InteriorSubNode1/LeafNode1", Item) == NS_DM_Client::e_Ok);
//
//    NS_DM_Client::String prop_name = "ACL";
//    NS_DM_Client::String prop_value = "Get=*";
//
// 	BOOST_CHECK(S_treeManager.ReplacePropertyValue(
// 	    "ReplacePropertyValueAndRollback/Root/InteriorSubNode1/LeafNode1", prop_name, prop_value) == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
//    prop_value = "Get=www.test.com";
//
// 	BOOST_CHECK(S_treeManager.ReplacePropertyValue(
// 	    "ReplacePropertyValueAndRollback/Root/InteriorSubNode1/LeafNode1", prop_name, prop_value) == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Rollback() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.GetPropertyValue(
// 	    "ReplacePropertyValueAndRollback/Root/InteriorSubNode1/LeafNode1", prop_name, prop_value) == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(prop_value.compare("Get=*") == 0);
//
//    fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/ReplacePropertyValueAndRollback");
//}
//
//BOOST_AUTO_TEST_CASE(CopyExistingLeafNodeToExistingDestinationAndRollback)
//{
// 	Funambol::Item Item;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	Item.setMeta(&meta);
// 	Item.setData(&Funambol::ComplexData("source value"));
//
// 	BOOST_CHECK(S_treeManager.Add("CopyExistingLeafNodeToExistingDestinationAndRollback/Root/InteriorSubNode1/sourceNode", Item) == NS_DM_Client::e_Ok);
//
//    Funambol::ComplexData new_data("original value");
//    Item.setData(&new_data);
//
// 	BOOST_CHECK(S_treeManager.Add("CopyExistingLeafNodeToExistingDestinationAndRollback/Root/InteriorSubNode1/destNode", Item) == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Copy("CopyExistingLeafNodeToExistingDestinationAndRollback/Root/InteriorSubNode1/sourceNode",
// 	    "CopyExistingLeafNodeToExistingDestinationAndRollback/Root/InteriorSubNode1/destNode") == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Rollback() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Get("CopyExistingLeafNodeToExistingDestinationAndRollback/Root/InteriorSubNode1/destNode", Item) == NS_DM_Client::e_Ok);
//
//    NS_DM_Client::String val = Item.getData()->getData();
// 	BOOST_CHECK(val.compare("original value") == 0);
//
//    fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/CopyExistingLeafNodeToExistingDestinationAndRollback");
//}
//
//
//BOOST_AUTO_TEST_CASE(CopyExistingLeafNodeToNotExistingDestinationAndRollback)
//{
// 	Funambol::Item Item;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	Item.setMeta(&meta);
// 	Item.setData(&Funambol::ComplexData("source value"));
//
// 	BOOST_CHECK(S_treeManager.Add("CopyExistingLeafNodeToExistingDestinationAndRollback/Root/InteriorSubNode1/sourceNode", Item) == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Copy("CopyExistingLeafNodeToExistingDestinationAndRollback/Root/InteriorSubNode1/sourceNode",
// 	    "CopyExistingLeafNodeToExistingDestinationAndRollback/Root/InteriorSubNode2/destNode") == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Rollback() == NS_DM_Client::e_Ok);
//
// 	BOOST_CHECK(S_treeManager.Get("CopyExistingLeafNodeToExistingDestinationAndRollback/Root/InteriorSubNode2/destNode", Item) == NS_DM_Client::e_NotFound);
//
//    fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/CopyExistingLeafNodeToExistingDestinationAndRollback");
//}
//
//BOOST_AUTO_TEST_CASE(CopyInteriorNodeAndRollback)
//{
//	NS_DM_Client::Node root("CopyInteriorNodeAndRollback/RootNode", S_dataStorage);
//	fs::path root_path(NS_DM_Client::NS_DataStorage::GetBasePath() + (NS_DM_Client::String)"/"
//	    + c_testProfile + (NS_DM_Client::String)"/" + "CopyInteriorNodeAndRollback/RootNode", fs::native);
//
//	root.SetProperty(NS_DM_Client::e_format, "node");
//	root.SetProperty(NS_DM_Client::e_type, "node");
//	root.SetProperty(NS_DM_Client::e_ACL, "Get=*&Add=*");
//	BOOST_CHECK(fs::exists(root_path));
//
//	// add childs
//	std::string uri = "CopyInteriorNodeAndRollback/RootNode/Node1/Node2/SourceNode";
//	Funambol::Item sourceItem;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	sourceItem.setMeta(&meta);
//	std::string oldContent("Some data");
//	sourceItem.setData(&Funambol::ComplexData(oldContent.c_str()));
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.Add(uri, sourceItem));
//
//	uri = "CopyInteriorNodeAndRollback/RootNode/Subnode/Node1/SourceNode";
//	sourceItem.setData(&Funambol::ComplexData(oldContent.c_str()));
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.Add(uri, sourceItem));
//
//	uri = "CopyInteriorNodeAndRollback/RootNode/Subnode/Node2/SourceNode2";
//	sourceItem.setData(&Funambol::ComplexData(oldContent.c_str()));
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.Add(uri, sourceItem));
//
//	uri = "CopyInteriorNodeAndRollback/RootNode/Subnode/LeafNode";
//	sourceItem.setData(&Funambol::ComplexData(oldContent.c_str()));
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.Add(uri, sourceItem));
//
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.Copy("CopyInteriorNodeAndRollback/RootNode", "CopyInteriorNodeAndRollback/copy_dest"));
//
// 	BOOST_CHECK(S_treeManager.Rollback() == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(S_treeManager.Get("CopyInteriorNodeAndRollback/copy_dest", sourceItem) == NS_DM_Client::e_NotFound);
//
//    fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/CopyInteriorNodeAndRollback/RootNode");
//}
//
//BOOST_AUTO_TEST_CASE(ReplaceNamePropertyOfNodeAndRollback)
//{
//	NS_DM_Client::Node root("ReplaceNamePropertyOfNodeAndRollback/RootNode", S_dataStorage);
//	fs::path root_path(NS_DM_Client::NS_DataStorage::GetBasePath() + (NS_DM_Client::String)"/"
//	    + c_testProfile + (NS_DM_Client::String)"/" + "ReplaceNamePropertyOfNodeAndRollback/RootNode", fs::native);
//
//	root.SetProperty(NS_DM_Client::e_format, "node");
//	root.SetProperty(NS_DM_Client::e_type, "node");
//	root.SetProperty(NS_DM_Client::e_ACL, "Get=*&Add=*");
//	BOOST_CHECK(fs::exists(root_path));
//
//	// add childs
//	std::string uri = "ReplaceNamePropertyOfNodeAndRollback/RootNode/Node1/Node2/SourceNode";
//	Funambol::Item sourceItem;
//	Funambol::Meta meta;
//	meta.setFormat("chr");
//	meta.setType("text/plain");
//	sourceItem.setMeta(&meta);
//	std::string oldContent("Some data");
//	sourceItem.setData(&Funambol::ComplexData(oldContent.c_str()));
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.Add(uri, sourceItem));
//
//	uri = "ReplaceNamePropertyOfNodeAndRollback/RootNode/Subnode/Node1/SourceNode";
//	sourceItem.setData(&Funambol::ComplexData(oldContent.c_str()));
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.Add(uri, sourceItem));
//
//	uri = "ReplaceNamePropertyOfNodeAndRollback/RootNode/Subnode/Node2/SourceNode2";
//	sourceItem.setData(&Funambol::ComplexData(oldContent.c_str()));
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.Add(uri, sourceItem));
//
//	uri = "ReplaceNamePropertyOfNodeAndRollback/RootNode/Subnode/LeafNode";
//	sourceItem.setData(&Funambol::ComplexData(oldContent.c_str()));
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.Add(uri, sourceItem));
//
//	BOOST_CHECK(S_treeManager.StartTransaction() == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.ReplacePropertyValue("ReplaceNamePropertyOfNodeAndRollback/RootNode", "Name", "ReplacedNode"));
//
// 	BOOST_CHECK(S_treeManager.Rollback() == NS_DM_Client::e_Ok);
//
//	BOOST_CHECK(NS_DM_Client::e_Ok == S_treeManager.Get("ReplaceNamePropertyOfNodeAndRollback/RootNode/Subnode/Node2/SourceNode2", sourceItem));
//
//    fs::remove_all(NS_DM_Client::NS_DataStorage::GetBasePath() +
//        (NS_DM_Client::String)"/" + c_testProfile + "/ReplaceNamePropertyOfNodeAndRollback");
//}
//
