/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "syncml/core/Add.h"
#include "syncml/core/Item.h"
#include "syncml/core/Source.h"
#include "commontypes.h"
#include "Errors.h"
#include "identifiers.h"

#include "executionqueue/IExecutionQueue.h"
#include "Logger/Logger.h"
#include "Logger/LoggerMacroses.h"
#include "treemanager/MOTreeAddCommand.h"
#include "treemanager/IMOTreeManager.h"

#include "serverexchange/firmware/FUMODefines.h"

static const char * const c_LogName = "MOTreeAddCommand";

#define LOG_INFO_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log

using namespace NS_DM_Client;


MOTreeAddCommand::MOTreeAddCommand(ProfileComponentsHolder* prholder,
								   AddPtr& cmd,
								   const String& msgID,
								   const char* serverId)
    : ActionCommand(prholder, cmd, msgID, serverId), m_AddCommand(cmd)
{
}


MOTreeAddCommand::~MOTreeAddCommand(void)
{
}


bool MOTreeAddCommand::Execute()
{
    GDLINFO("FUNCTION STARTED");

    bool res = m_pProfile && m_AddCommand.get();
    if (res)
    {
        res = false;
		m_resCode = performOperation();
		res = InvokeResult();
    }
    else
    {
    	GDLERROR("component holder or command instanse not valid");
    }

    GDLINFO("FUNCTION END. Res: %d", res);
    return res;
}


StatusCode MOTreeAddCommand::performOperation()
{
    StatusCode res = e_Ok;
    Funambol::ArrayList* items = m_AddCommand->getItems();
    if (items)
    {
        Funambol::Item* item = 0;
        int count = items->size();
        for (int i = 0; i < count; ++i)
        {
            if ((item = dynamic_cast<Funambol::Item*> ((*items)[i])) != 0)
            {
                const URI uri = item->getTarget()->getLocURI();
                if (e_Ok == (res = m_pProfile->GetMOTreeManager()->Add(uri, *item, m_serverID)))
                {
                	perocessAddOnFUMO(uri.c_str(), *item);
                }
                else
                {
                	GDLDEBUG("add item to MO Tree Manager failed");
                    break;
                }
            }
            else
            {
                GDLDEBUG("casting to Funambol::Item failed");
                break;
            }
        }
    }
    else
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_LogName),
            "%s", "get items from ItemizedCommand failed");
    }
    return res;
}

void MOTreeAddCommand::perocessAddOnFUMO(const char *uri, Funambol::Item &item)
{
	Funambol::Meta *pMeta = item.getMeta();
	if (pMeta && pMeta->getType())
	{
		if (!strcmp(pMeta->getType(), FUMO_TYPE))
		{
			Funambol::StringBuffer state_uri(uri);
			if (uri)
			{
				if (uri[strlen(uri)-1] != '/')
				{
					state_uri.append("/");
				}
				state_uri.append("State");
			}

			// add Status node
			Funambol::Item itemStatus;
			Funambol::Target target(state_uri.c_str());
			Funambol::Meta meta;
			meta.setType("text/plain");
			meta.setFormat("int");
			itemStatus.setTarget(&target);
			itemStatus.setMeta(&meta);

			char buffer[16] = {0};
			sprintf(buffer, "%d", NS_Communication::FS_NO_PENDING_OPERATIONS);
			Funambol::ComplexData data(buffer);
			itemStatus.setData(&data);

			StatusCode res;
			res = m_pProfile->GetMOTreeManager()->Add(state_uri.c_str(), itemStatus, NULL);
			GDLDEBUG("adding Status node finished with status %d", res);
		}
	}
}
