/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "treemanager/MOTreeGetCommandTest.h"
#include "treemanager/IMOTreeManager.h"

#include "syncml/core/Get.h"
#include "syncml/core/Item.h"
#include "syncml/core/Source.h"

#include "commontypes.h"

#include "Logger/Logger.h"

#include "common/Buffer.h"

const char* const c_GetCommandLog = "MOTreeGetCommand";

#define LOG_INFO_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log

namespace NS_DM_Client
{
//------------------------------------------------------------------------------------------------------
MOTreeGetCommandTest::MOTreeGetCommandTest(ProfileComponentsHolder* prholder,
    GetPtr& command, const String& msgID, NS_Common::EventEx* sigEvent,
    StatusCode& result_status, Buffer& result)
    : MOTreeGetCommand(prholder, command, msgID), m_resultStatus(result_status), m_result(result), m_sigEvent(sigEvent),  m_executed(false)
{

}
//------------------------------------------------------------------------------------------------------
MOTreeGetCommandTest::~MOTreeGetCommandTest(void)
{
    m_sigEvent->signal(m_executed ? e_CommandExecuted : e_CommandDestroyed);
}
//------------------------------------------------------------------------------------------------------
bool MOTreeGetCommandTest::Execute()
{
    return MOTreeGetCommand::Execute();
    //m_resultStatus = (MOTreeGetCommand::Execute()) ? e_Ok : e_Failed;
    //return m_resultStatus == e_Ok;
}
//------------------------------------------------------------------------------------------------------
bool MOTreeGetCommandTest::InvokeResult()
{
    bool res = false;
    if (m_resCode == e_Ok)
    {
        Funambol::ArrayList& results = *(m_GetCommand.get()->getItems());
	    for (int i=0; i<results.size(); ++i)
	    {
		    Funambol::Item *pItem = (Funambol::Item*)results.get(i);
		    if (pItem && pItem->getTarget() && pItem->getData())
		    {
                const char* data = pItem->getData()->getData();
                m_result.Allocate(strlen(data));
                memcpy(m_result.GetPointer(), data, strlen(data));
                res = true;
                m_resultStatus = e_Ok;
		    }
	    }
    }
    else if (m_resCode == e_NotFound)
    {
        m_resultStatus = e_NotFound;
    }
    else if (m_resCode == e_OptionalFeatureNotSupported)
    {
        m_resultStatus = e_OptionalFeatureNotSupported;
    }
    else
    {
        m_resultStatus = e_Failed;
    }
    m_executed = true;
    return res;
}

}
