/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include <syncml/core/Add.h>
#include <syncml/core/Item.h>
#include <syncml/core/Source.h>

#include "commontypes.h"
#include "daemon/ProfileComponentsHolder.h"
#include "Logger/LoggerMacroses.h"
#include "treemanager/IMOTreeManager.h"
#include "treemanager/MOTreeResponseCommand.h"
#include "serverexchange/ICommandsSink.h"
#include "serverexchange/IServerExchangeManager.h"
#include "serverexchange/wrappers/SCommandFactory.h"

const char* const c_LogName = "MOTreeResponseCommand";

using namespace NS_DM_Client;
using namespace NS_SyncMLCommand;


MOTreeResponseCommand::MOTreeResponseCommand(ProfileComponentsHolder* prholder,
											 AbstractCommandPtr cmd,
											 StatusCode cmdStatus,
											 const String& msgID,
											 const char *serverID)
    : m_pProfile(prholder), m_command(cmd), m_status(cmdStatus), m_messageID(msgID), m_serverID(NULL), m_pCommandsSink(NULL)
{
	if (serverID)
		m_serverID = Funambol::stringdup(serverID);
}


MOTreeResponseCommand::~MOTreeResponseCommand()
{
	SAFE_DELETE(m_serverID);
}


bool MOTreeResponseCommand::Execute()
{
    bool res = m_pProfile && m_command.get();
    if (res)
    {
		res = false;
		res = performOperation();
    }
    else
    {
        GDLERROR("%s", "component holder or command instanse not valid");
    }

    return res;
}


void MOTreeResponseCommand::SetCommandsSink(NS_SyncMLCommand::ICommandsSink &sink)
{
	m_pCommandsSink = &sink;
}


void MOTreeResponseCommand::enqueueCommand(NS_SyncMLCommand::SCommandPtr ptrCommand)
{
	if (m_serverID && m_pCommandsSink)
		m_pCommandsSink->AddCommand(ptrCommand, m_serverID);
	else
		GDLERROR("!losing command's response: no serverID or SEM instance is set ['%s','%x']", m_serverID ? m_serverID : "", m_pCommandsSink);
}


bool MOTreeResponseCommand::performOperation()
{
	bool res = false;

	SStatusCommandPtr ptrStatus = SCommandFactory::CreateStatus(m_status, m_command);
	if (ptrStatus.get())
	{
		enqueueCommand(ptrStatus);
		res = true;
	}
	else
	{
		GDLERROR("%s", "SCommandFactory::CreateStatusMessage failed");
	}

	return res;
}
