/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */


#include <syncml/core/AbstractCommand.h>
#include <syncml/core/Item.h>
#include <syncml/core/Sequence.h>
#include <syncml/core/Source.h>

#include "commontypes.h"
#include "executionqueue/IExecutionQueue.h"
#include "Logger/LoggerMacroses.h"

#include "treemanager/IMOTreeManager.h"
#include "treemanager/MOTreeAddCommand.h"
#include "treemanager/MOTreeCopyCommand.h"
#include "treemanager/MOTreeDeleteCommand.h"
#include "treemanager/MOTreeGetCommand.h"
#include "treemanager/MOTreeReplaceCommand.h"
#include "treemanager/MOTreeExecCommand.h"
#include "treemanager/MOTreeSequenceCommand.h"
#include "serverexchange/wrappers/SCommandFactory.h"
#include "serverexchange/IServerExchangeManager.h"


using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_SyncMLCommand;

const char* const c_LogName = "MOTreeSequenceCommand";

MOTreeSequenceCommand::MOTreeSequenceCommand(ProfileComponentsHolder* prholder,
											 SequencePtr cmd,
											 const String& msgID,
											 const char* serverId) :
	ActionCommand(prholder, cmd, msgID, serverId), m_SequenceCommand(cmd)
{
}


MOTreeSequenceCommand::~MOTreeSequenceCommand()
{
}


bool MOTreeSequenceCommand::Execute()
{
	if (!m_pProfile || !m_SequenceCommand.get())
	{
		GDLERROR("component holder or command instanse not valid");
		return false;
	}

	Funambol::Sequence *seq = m_SequenceCommand.get();
	Funambol::ArrayList *cmds = seq->getCommands();
	if (!cmds || cmds->isEmpty())
	{
		m_resCode = e_Ok;
	}
	else
	{
		m_resCode = processCommands(*cmds);
	}

	InvokeResult();

	return true;
}


ActionCommand * MOTreeSequenceCommand::createProcessingCommand(Funambol::AbstractCommand &cmd)
{
	const char *name = cmd.getName();
	
	if (name && !strcmp(name, ADD_COMMAND_NAME))
	{
		AddPtr ptrAdd((Funambol::Add*)cmd.clone());
		return new MOTreeAddCommand(m_pProfile, ptrAdd, m_messageID, m_serverID);
	}
	else if (name && !strcmp(name, COPY_COMMAND_NAME))
	{
		CopyPtr ptrCopy((Funambol::Copy*)cmd.clone());
		return new MOTreeCopyCommand(m_pProfile, ptrCopy, m_messageID, m_serverID);
	}
	else if (name && !strcmp(name, DELETE_COMMAND_NAME))
	{
		DeletePtr ptrDelete((Funambol::Delete*)cmd.clone());
		return new MOTreeDeleteCommand(m_pProfile, ptrDelete, m_messageID, m_serverID);
	}
	else if (name && !strcmp(name, GET_COMMAND_NAME))
	{
		GetPtr ptrGet((Funambol::Get*)cmd.clone());
		return new MOTreeGetCommand(m_pProfile, ptrGet, m_messageID, m_serverID);
	}
	else if (name && !strcmp(name, REPLACE_COMMAND_NAME))
	{
		ReplacePtr ptrReplace((Funambol::Replace*)cmd.clone());
		return new MOTreeReplaceCommand(m_pProfile, ptrReplace, m_messageID, m_serverID);
	}
	else if (name && !strcmp(name, EXEC_COMMAND_NAME))
	{
		ExecPtr ptrExec((Funambol::Exec*)cmd.clone());
		return new MOTreeExecCommand(m_pProfile, ptrExec, m_messageID, m_serverID);
	}
	return NULL;
}


// MOTreeSequenceCommand executes inner commands within itself, without sending them 
// to the ExecutionQueue (it is expected that MOTreeSequenceCommand is already placed into the ExecutionQueue)
StatusCode MOTreeSequenceCommand::processCommands(Funambol::ArrayList &clist)
{
	StatusCode res = e_Ok;
	Funambol::AbstractCommand* cmd = NULL;

	int count = clist.size();
	GDLDEBUG("Sequence has %d internal commands", count);
	for (int i=0; i<count; ++i)
	{
		if ((cmd = dynamic_cast<Funambol::AbstractCommand*>(clist[i])))
		{
			ActionCommand *treecmd = createProcessingCommand(*cmd);

			if (treecmd)
			{
				GDLDEBUG("Received command %x", treecmd);
				if (m_pCommandsSink)
					treecmd->SetCommandsSink(*m_pCommandsSink);

				treecmd->Execute();
				delete treecmd;
			}
			else
			{
				GDLERROR("Failed to create handling command");
			}
		}
		else
		{
			GDLERROR("casting to Funambol::AbstractCommand failed, command index = %d", i);
		}
	}

	GDLDEBUG("result StatusCode = %d", res);
	return res;
}

