/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include <cstdlib>

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	class IFirmwareUpdater
	{
	public:
		enum EnumFirmwareStatus
		{
			e_OK = 0,
			e_DeviceNotReady,
			e_FirmwareStorageFailure,
			e_FirmwareStorageOverflow,
			e_FirmwareUpdateFailed,
			e_FirmwareUpdateFailedBecausePackageIsCorrupted
		};

		virtual ~IFirmwareUpdater(){}

		virtual bool Init(NS_Logging::Logger* logger) = 0;

		virtual EnumFirmwareStatus InitStorage(const char* packageName = 0, const char* location = 0) = 0;
		virtual EnumFirmwareStatus ResetStorage() = 0;
		virtual EnumFirmwareStatus AppendChunk(const char* buffer, size_t size, bool last) = 0;
		virtual EnumFirmwareStatus Update() = 0;

	};
}

