/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include <commontypes.h>

namespace NS_DM_Client
{
	class TNDSCreator
	{
	public:
		TNDSCreator();
		~TNDSCreator();

		void Append(const String& path, const String& name, const String& value);
		void Append(const String& path, const String& name, bool value); ////
		void Append(const String& path, const String& name, size_t value);
		void Append(const String& path, const String& nodeName); // append node
		void Get(String& xml);

	private:
		void appendVersion();
		void appendValue(Funambol::StringBuffer*& nodeXml, const String& target, const String& value);
		void append(const String& path, const String& name, const String& format, const String& value = "");

	private:
		Funambol::StringBuffer* m_buffer;
	};
}
