/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <platform.h>
#include <vector>

#include <commontypes.h>

namespace NS_DM_Client
{

namespace NS_NotificationListener
{

    class NotificationMessage
    {
    public:
        NotificationMessage();
        ~NotificationMessage();

        enum HeaderSize
        {
            HEADER_SIZE  = 24
        };

        bool    SetMessage(const void*  msg, size_t size);

        typedef buffer_t diggest_t;
        bool    CheckDiggest() const;

        enum
        {
            VERSION = 0x0B  // 0000001011
        };

        int                 GetVersion() const;

        enum EnumUIMode
        {
            e_UI_NotDefined         =   0x00,
            e_UI_Background         =   0x01,
            e_UI_Informative        =   0x02,
            e_UI_UserInteraction    =   0x03
        };
        EnumUIMode      GetUIMode() const;

        enum EnumInitiator
        {
            e_InitiatorClient   = 0,
            e_InitiatorServer   = 1
        };
        EnumInitiator   GetInitiator() const;

        typedef unsigned short  session_id_t;
        session_id_t    GetSessionID() const;
        bool            GetSessionID(String& sessionID) const;

        const char*     GetServerID() const;

        typedef std::vector<char>   body_t;
        bool    HasBody() const;
        bool    GetBody(body_t& body) const;

    private:
        size_t          getServerIDLength() const;
        const char*     getServerIDRef() const;

    private:
        buffer_t   m_message;
    #ifdef PLT_BIG_ENDIAN
        buffer_t&  m_header;
    #else
        buffer_t   m_header;
    #endif

        diggest_t      m_diggest;
        String         m_server_id;
    };

}

}
