/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <vector>

namespace NS_DM_Client
{

class Buffer
{
public:
    Buffer();
    Buffer(const size_t size);
    Buffer(const size_t sizeconst, char val);
    ~Buffer();
    bool Allocate(const size_t size);
    bool Allocate(const size_t size, const char val);
    size_t Size() const;
    void* GetPointer();
    const void* GetPointer() const;
    bool Release();
    void Clear();
private:
    std::vector<char> m_Data;
};

};
