/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <pthread.h>
#include "CritSection.h"

namespace NS_DM_Client
{
	namespace NS_Common
	{
		/// Class represents a conditinal variable sync object
		class CondVariable
		{
		public:
			CondVariable()				{	pthread_cond_init(&m_condition, NULL);			}
			~CondVariable() 			{	pthread_cond_destroy(&m_condition);				}

			void Wait(CritSection &cs)	{	pthread_cond_wait(&m_condition, &cs.m_mutex);	}
			void Signal()				{	pthread_cond_signal(&m_condition);				}

		private:
			pthread_cond_t m_condition;
		};
	}
}

