/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

namespace NS_DM_Client
{
	namespace NS_Common
	{
		class Event
		{
		public:
			Event(bool autoReset = true);
			virtual ~Event();

			void wait();
			void reset();
			void signal();

		private:
			void* m_handle;
		};

		class EventEx : private Event
		{
        public:
            enum
            {
                e_NotDefined = 0,
                e_Stop = 1,

                e_UserSignal
            };
            
            EventEx()
                : m_param(e_NotDefined)
                {}

            ~EventEx()
            { m_param = e_NotDefined; }


            long    wait();
            void    signal(long param);
            void    signal() { signal(e_NotDefined); }

        private:
            volatile long m_param;

		};

	}
}
