/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <daemon/types.h>

#include <base/util/XMLProcessor.h>
#include <vector>

namespace NS_Logging
{
    class Logger;
}

namespace NS_DM_Client
{
    class DynamicLoader;

    namespace NS_Daemon
	{
        class Profile;
		class ComponentInfo;

		class Configuration
		{
		public:
			Configuration(NS_Logging::Logger& log);
			virtual ~Configuration(void);

			virtual bool Read(StringBuffer& xml);

			virtual int GetProfilesCount() const;
			virtual Profile* GetProfile(int i);
			virtual Profile* GetProfile(const String& profileName);

		private:
            void reset();

            bool readProfiles(StringBuffer& xml);
			bool addProfile(Profile& profile, StringBuffer& xml, bool enable = false);

		public:
			static bool S_getTagInfo(const char* xml, const char* tagName, StringBuffer& content, StringBuffer* attributes = NULL, unsigned int* end_pos = NULL);
			static bool S_getAttribute(const char* xml, const char* attName, StringBuffer& attrValue);
            static bool S_readSettings(StringBuffer& xml, StringMap& params);
            static bool S_readLoggerInfo(StringBuffer& xml, StringBuffer& loggerInstance);
            static bool S_readLocation(StringBuffer& xml, StringBuffer& modulename, StringBuffer& createFuncName);

        private:
            typedef std::vector<Profile*>   Profiles;
            Profiles   m_Profiles;

            NS_Logging::Logger& m_logger;

		};

	}
}

