/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <commontypes.h>

#include <daemon/ProfileComponentsHolder.h>

namespace NS_DM_Client
{
	class IComponent
	{
	public:
		virtual ~IComponent(){}

 		virtual bool Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch) = 0;
		virtual bool Start() = 0;
		virtual bool Stop() = 0;
		virtual void Release() = 0;

	protected:
		IComponent(){}
	
	private:
		IComponent(IComponent&);
		IComponent& operator = (IComponent&);


	};

}
