/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <syncml/core/DevInf.h>
#include <spds/AccessConfig.h>
#include "daemon/IManager.h"
#include "wrappers/SCommandAdapter.h"
#include "serverexchange/ConnectionInfo.h"
#include "serverexchange/IConnection.h"
#include "serverexchange/ICommandsSink.h"
#include "NotificationListener/SessionInfo.h"

namespace Funambol {
	class DevInf;
	class AccessConfig;
}


namespace NS_DM_Client
{
	namespace NS_Communication {
		class FirmwareManager;
	}

	/// Interface represents component that is capable of communication with DM server.
	class IServerExchangeManager : public IManager, public NS_SyncMLCommand::ICommandsSink
	{
	public:
		/// Get the default DM connection; may be NULL
		virtual NS_Communication::IConnection * DefaultConnection() = 0;

		virtual void DefaultConnectionName(String &) = 0;

		virtual void HandleNetworkEntrance(int homeNspID, const char* operatorName, bool startWIB) = 0;

		/// 
		virtual void NotifyDiagnosticsReady(String &serverID, String &origID) = 0;
		
		/// 
		virtual void NotifyFWJobStatus(String &serverID, int result, ExecPtr &exec, const char *alertType) = 0;

		/// check whether the SEM has account in of for serverID
		virtual bool HasAccountFor(String &serverID) = 0;

		/// Configure server poller
		virtual void SetServerPollerInfo(bool supported, int interval, int attempts) = 0;

		/// Set list of account read from the DMAcc node
		virtual void SetConnectionsInfo(NS_Communication::ConnInfoList &) = 0;

		/// Set device info read from the management tree
		virtual void SetDevInfo(Funambol::DevInf &devInf) = 0;

		/// Start client initiated session on the default dm connection
		virtual void StartClientSession() = 0;

		virtual void StartClientSession(NS_SyncMLCommand::SAlertCommandPtr ptrAlert) = 0;

		/// Send request to server about firmware availability
		/// @param userInitiated true - user initiated request; false - device initiated request
		/// @param fumouri indicates uri in dm tree, that might be user by server to provide new fw; may be null
		/// @param data additinal manufacturer specific data
		virtual void RequestFWUpdate(bool userInitiated, const char *fumouri, int data) = 0;

		/// Request to start dm session
		/// @param sessionInfo contains parameters of the connection (serverid etc.)
		/// TODO - rename to RequestSessionStart ??
		virtual void RequestSessionStart(const NS_NotificationListener::SessionInfo& sessionInfo) = 0;

		virtual NS_Communication::FirmwareManager* GetFirmwareManager() = 0;
		virtual void ProcessBootstrapMessage(const char *bsm, uint length) = 0;

		virtual void StartWIB() = 0;
	};
}
