/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "Timer.h"
#include "serverexchange/CommandStorage.h"
#include "serverexchange/LOResults.h"
#include "serverexchange/LOSendingStrategy.h"
#include "serverexchange/SendingStrategy.h"


namespace NS_DM_Client
{
	namespace NS_Communication
	{
		class LOSendingStrategy : public SendingStrategy
		{
		public:
			LOSendingStrategy(ConnectionInfo &, NS_SyncMLCommand::CommandStorage &, ISession &);
			virtual ~LOSendingStrategy();

			virtual Status Send();
			bool Finished();
		private:
			int m_currentIndex;
			NS_SyncMLCommand::LOResults *m_pLOResults;
			NS_SyncMLCommand::CommandStorage &m_commands;
			bool canFitCommandInto(NS_SyncMLCommand::SCommandPtr, int emptyMsgSize);
		};
	}
}
