/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "daemon/ProfileComponentsHolder.h"
#include "treemanager/MOTreeCommand.h"

namespace NS_DM_Client
{
	class ProfileComponentsHolder;
	
	namespace NS_Communication
	{
		class ConnectionInfo;

#define AUTH_TYPE_MAC	"syncml:auth-MAC"
#define CLCRED			"CLCRED"
#define SRVCRED			"SRVCRED"
		
		/// Class implements command that read all accounts from the ./DMAcc node and sends them to the SEM
		class DMAccountCommand : public MOTreeCommand, protected PCHAware
		{
		public:
			DMAccountCommand(ProfileComponentsHolder &pch);
			virtual bool Execute();

		protected:
			IMOTreeManager &m_treeManager;
			bool getAuthenticationNode(FStringBuffer & uriAccount, FStringBuffer & result, const char *authname);
			bool getLeafValue(FStringBuffer & uriAccount, const char * leafname, FStringBuffer & result);
			bool getServerNode(FStringBuffer & uriAccount, FStringBuffer & result);
			bool setLeafValue(FStringBuffer & uriNode, const char * leafname, FStringBuffer &value);

			ConnectionInfo * readAccount(FStringBuffer &uriAccount);
bool IsDMAccNode(IMOTreeManager &tm, const char *uri);

		private:
			FStringBuffer m_uriServerNode;
			FStringBuffer m_uriAuthNode;
			void getServerPort(FStringBuffer & result);
		};
	}
}
