/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "serverexchange/commands/ServerExchangeCommand.h"
#include "serverexchange/firmware/FUMODefines.h"
#include "serverexchange/wrappers/SCommandAdapter.h"

namespace NS_DM_Client
{
	class ProfileComponentsHolder;
	
	class FWStatusCommand : public ServerExchangeCommand
	{
	public:
		FWStatusCommand(IServerExchangeManager &sem,
						ExecPtr cmd, NS_DM_Client::NS_Communication::FWCmdStatus cmdStatus, 
						const char *serverid, const char *responseType);

		virtual bool Execute();

	private:
		ExecPtr    m_ExecCommand;
		NS_DM_Client::NS_Communication::FWCmdStatus m_cmdStatus;
		String m_serverID;
		String m_responseType;
	};
}
