/*
 * Copyright 2010 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "Session.h"

namespace NS_DM_Client
{
	namespace NS_Communication
	{
		/// Class implements session based on the DIGEST authentication scheme
		class MD5Session : public Session
		{
		public:
			MD5Session(ConnectionInfo &info, Funambol::TransportAgent &);
			virtual ~MD5Session();
			
			virtual bool AcceptsNonces() { return true; };
			virtual bool CredentialsSent();
			virtual NS_SyncMLCommand::SStatusCommand* CreateSyncHdrStatus(int code, const char * responseURI);
			virtual const char * GetTypeName();
			virtual bool IsServerCredValid(Funambol::Cred *);
			virtual bool ReadChal(Funambol::Chal &);

		protected:
			bool m_credentialsSent;
			virtual void insertSessionInitiationCommands(int code);
		};
	}
}
