/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "daemon/ProfileComponentsHolder.h"
#include "treemanager/IMOTreeManagerListener.h"

namespace NS_DM_Client
{

class FUMORefUpdateListener : public IMOTreeManagerListener
{

public:
    FUMORefUpdateListener(ProfileComponentsHolder& pch);
    virtual ~FUMORefUpdateListener() { }

    virtual bool Init(ProfileComponentsHolder& pch);
    virtual bool Release();

    bool SetDefaultValue(const String& defValue);

    virtual bool ExecuteOnAdd(const URI& uri);
    virtual bool ExecuteOnDelete(const URI& uri);
    virtual bool ExecuteOnReplace(const URI& uri);
    virtual bool ExecuteOnReplaceProperty(const URI& uri, const String& property_name);
    virtual bool ExecuteOnCopy(const URI& source, const URI& dest);
private:
    bool isListenURI(const URI& uri) const;

    ProfileComponentsHolder& m_component_holder;
    String m_defValue;
};


}
