/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "Errors.h"
#include "commontypes.h"
#include "daemon/IComponent.h"

namespace Funambol
{
    class Item;
}

namespace NS_DM_Client
{
	enum TNDSProperty
	{
		e_TNDS_ACL,
		e_TNDS_format,
		e_TNDS_name,
		e_TNDS_size,
		e_TNDS_title,
		e_TNDS_tstamp,
		e_TNDS_type,
		e_TNDS_verNo,
		e_TNDS_value
	};

	class IMOTreeManager: public IComponent
	{
	public:
        typedef std::vector<URI> ChildrenPaths;
		typedef std::vector<TNDSProperty> RequiredProperties;

		virtual bool Exist(const URI& uri, const char* serverId = 0) = 0;
		virtual StatusCode Get(const URI& uri, Funambol::Item& item, const char* serverId = 0) = 0;
		virtual StatusCode GetValue(const URI& uri, String& value, const char* serverId = 0) = 0; // works for leaves only
		virtual StatusCode GetPropertyValue(const URI& uri, const String& property_name, String& value, const char* serverId = 0) = 0; // works for leaves only
		virtual StatusCode GetChildren(const URI& uri, ChildrenPaths& children, const char* serverId = 0) = 0; // for interior node only
		virtual StatusCode GetAttributeStructData(const URI& uri, Funambol::ArrayList& items, bool keepData = true, const char* serverId = 0) = 0;
		virtual StatusCode GetAttributeTNDS(const URI& uri, const RequiredProperties& requiredProp, Funambol::StringBuffer*& xml, const char* serverId = 0) = 0;

		virtual StatusCode Add(const URI& uri, const Funambol::Item& item, const char* serverId = 0, bool isUpdateRequired = true) = 0;
		virtual StatusCode Delete(const URI& uri, const char* serverId = 0) = 0;
		virtual StatusCode Replace(const URI& uri, const Funambol::Item& item, const char* serverId = 0, bool isUpdateRequired = true) = 0;

		virtual StatusCode ReplacePropertyValue(const URI& uri, const String& property_name, const String& new_value, const char* serverId = 0) = 0;

		virtual StatusCode Copy(const URI& source, const URI& dest, const char* serverId = 0) = 0; // works for leaves only

        virtual StatusCode ExecPermitted(const URI& path, const char* serverId = 0) = 0;

        virtual StatusCode SetPropertyValue(const URI& uri, const String& property_name, const String& value) = 0;

	    virtual StatusCode StartTransaction() = 0;
	    virtual StatusCode Rollback() = 0;
	    virtual StatusCode Commit() = 0;
	};
}
