/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "treemanager/MOTreeItemisedCommand.h"

namespace Funambol {
	class Item;
};

namespace NS_DM_Client
{
	#define URI_DIAGNOSTICS_START         "./WiMAX_Diagnostics/Start"
	#define URI_DIAGNOSTICS_DURATION      "./WiMAX_Diagnostics/Start/Duration"
	#define URI_DIAGNOSTICS_SERVERID      "./WiMAX_Diagnostics/Start/Server_ID"
	#define URI_DIAGNOSTICS_ORIGINATIONID "./WiMAX_Diagnostics/Start/Origination_ID"
	
    class MOTreeExecCommand : public MOTreeItemisedCommand
    {
    public:
        MOTreeExecCommand(ProfileComponentsHolder* prholder,
						 ExecPtr& command,
						 const String& msgID,
						 const char* serverId = 0);
        virtual ~MOTreeExecCommand() {}

		virtual bool Execute();
        StatusCode executeDownload(const char * fumouri, const char * fwmoexuri);
        StatusCode executeUpdate(const char * fumouri, const char * fwmoexuri);
        StatusCode executeDU(const char * fumouri, const char * fwmoexuri);

    protected:
        virtual Funambol::ArrayList* getListOfItems();

		ExecPtr m_ExecCommand;

    private:

        MOTreeExecCommand(const MOTreeExecCommand&);
        MOTreeExecCommand& operator =(const MOTreeExecCommand&);

		StatusCode executeDiagnostics();
        StatusCode executeItem(Funambol::Item &item);
        StatusCode performOperation();

        StatusCode processExecOnMultipleItems(Funambol::ArrayList* items, IMOTreeManager* treeManager);
    };
}
