/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include <vector>
#include "commontypes.h"

namespace NS_DM_Client
{
class ProfileComponentsHolder;
class IMOTreeManagerListener;
class MOTreeManagerListenerCollection
{
public:
    MOTreeManagerListenerCollection() { }
    ~MOTreeManagerListenerCollection() { }

    bool Init(ProfileComponentsHolder& pch, const StringMap& settings);

    bool AddListener(IMOTreeManagerListener* listener);

    bool ExecuteOnAdd(const URI& uri);
    bool ExecuteOnDelete(const URI& uri);
    bool ExecuteOnReplace(const URI& uri);
    bool ExecuteOnReplaceProperty(const URI& uri, const String& property_name);
    bool ExecuteOnCopy(const URI& source, const URI& dest);

    // call Release for all listeners
    bool Release();
private:
    MOTreeManagerListenerCollection(const MOTreeManagerListenerCollection&);
    MOTreeManagerListenerCollection& operator=(MOTreeManagerListenerCollection&);

    std::vector<IMOTreeManagerListener*> m_listeners;

    StringMap m_settings;
};

MOTreeManagerListenerCollection* GetMOTreeManagerListenerCollection(ProfileComponentsHolder& pch, const StringMap& settings);

};
