/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "DaemonDM/MessageListener.h"
#include "DaemonDM/IMessageHandler.h"
#include "MessengerDefs.h"
#include "IFIFOWrapper.h"

#include "Logger/Logger.h"

namespace NS_DM_Client
{
//------------------------------------------------------------------------------------------------------
StatusCode MessageListener::Init(IMessageHandler* message_handler)
{
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "ENTER >> MessageListener::Init");
    m_message_handler = message_handler;
    m_actionThread.Init(this);
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::Init, Return status: %d", e_Ok);
    return e_Ok;
}
//------------------------------------------------------------------------------------------------------
bool MessageListener::Release()
{
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "ENTER >> MessageListener::Release");
    if (m_message_handler)
    {
        m_message_handler->Release();
    }
    delete this;
    return true;
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::Release, Return status: %d", true);
}
//------------------------------------------------------------------------------------------------------
StatusCode MessageListener::WaitMessages()
{
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "ENTER >> MessageListener::WaitMessages");
    if (m_actionThread.running())
    {
        LOG_WARNING_(NS_Logging::GetLogger(c_MessageListenerLog), "%s", "lisener already wait for messages");
        LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::WaitMessages, Return status: %d", e_Ok);
        return e_Ok;
    }
    m_actionThread.start();
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::WaitMessages, Return status: %d", e_Ok);
    return e_Ok;
}
//------------------------------------------------------------------------------------------------------
StatusCode MessageListener::StopWaitingMessages()
{
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "ENTER >> MessageListener::StopWaitingMessages");
    if (!m_actionThread.running())
    {
        LOG_WARNING_(NS_Logging::GetLogger(c_MessageListenerLog), "%s", "lisener don't wait for messages. no need stop");
        LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::StopWaitingMessages, Return status: %d", e_Ok);
        return e_Ok;
    }
    IFIFOWrapper *fifo_stop_request, *fifo_stop_responce;
    if (!initializeFifos(fifo_stop_request, fifo_stop_responce, true))
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::StopWaitingMessages, Return status: %d, reason: initialize fifos failed", e_Failed);
        return e_Failed;
    }
    Buffer stop_request(sizeof(UIExchangeHead), '\0');
    memcpy(stop_request.GetPointer(), c_StopRequest, strlen(c_StopRequest)); // "stop\0" alvays smaller then sizeof(UIExchangeHead)
    if (fifo_stop_request->Write(stop_request) == e_Ok)
    {
        m_actionThread.wait();
    }
    else
    {
        releaseFifos(fifo_stop_request, fifo_stop_responce);
        LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::StopWaitingMessages, Return status: %d, reason: write to stop fifo failed", e_Failed);
        return e_Failed;
    }
    releaseFifos(fifo_stop_request, fifo_stop_responce);
    LOG_DEBUG_(NS_Logging::GetLogger(c_MessageListenerLog), "LEAVE << MessageListener::StopWaitingMessages, Return status %d:", e_Ok);
    return e_Ok;
}
//------------------------------------------------------------------------------------------------------
IMessageHandler* MessageListener::GetMessageHandler()
{
    return m_message_handler;
}
//------------------------------------------------------------------------------------------------------
MessageListener::~MessageListener()
{
}
//------------------------------------------------------------------------------------------------------


}
