/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */
#pragma once

////#ifndef DATASTORAGEDEFS_H_INCLUDED
////#define DATASTORAGEDEFS_H_INCLUDED

#include <sys/stat.h>
#include "commontypes.h"
#include "platform.h"
#include "FileSystemUtils.h"

namespace NS_DM_Client
{

namespace NS_DataStorage
{

#if defined(PLATFORM_ANDROID)
////const char* const c_privateDataPath = "/data/data/com.funambol.omadmclient.android.service/DataStorage";
const char* const c_privateDataPath = "/data/data/com.funambol.omadmclient.android.service/files/DataStorage";
#else
const char* const c_privateDataPath = "/etc/Funambol/DMClient/DataStorage";
#endif

const char* const c_streamSubPath = "/streams";

const char* const c_confFile = "conf/conf";
const char* const c_streamFileTemplate = "streams/stream_";

const char* const c_pathEmptyStr = "";

const char* const c_separatorReplacing = "%%";

const char* const c_privateDataExt = ".priv";
const char* const c_streamDataExt = ".strm";

const long c_MaxStreamNumber = 1000;

const char* const c_DataStorageLog = "DataStorage";
const char* const c_StreamHandlerLog = "StreamHandler";

char* itoa(int val, int base);
void str_replace(String& src, const String& what, const String& with);

const char c_pathSeparator = '/';
const char* const c_pathSeparatorStr = "/";

const mode_t c_fullAccessMode = S_IRWXU | S_IRWXG | S_IRWXO; // 0777
const mode_t c_fullAccessModeExceptExec = (S_IRWXU & ~ S_IXUSR) | (S_IRWXG & ~S_IXGRP) | (S_IRWXO & ~S_IXOTH);
const mode_t c_accessMode = c_fullAccessModeExceptExec;//c_fullAccessMode;

}

}

////#endif // DATASTORAGEDEFS_H_INCLUDED
