#include "DevInfo.h"
#include "treemanager/IMOTreeManager.h"
#include "Common.h"
#include "TNDSMgmtTree/TNDSCreator.h"
#include "TNDSMgmtTree/TNDSExtractor.h"

namespace NS_DM_Client
{
    const String DevInfoFieldPath[] =
    {
        "./DevInfo/",
        "./DevInfo/",
        "./DevInfo/",
        "./DevInfo/",
        "./DevInfo/"
    };

    const String DevInfoFieldName[] =
    {
        "DevId",
        "Man",
        "Mod",
        "DmV",
        "Lang"
    };

    MANAGEMENTOBJECTS_API int i;

    bool DevInfo::Serialize(IMOTreeManager& treeManager) const
    {
        bool res = NS_DM_Client::Serialize(DevInfoFieldPath[e_DevId] + DevInfoFieldName[e_DevId], m_DevId, treeManager);
        res &= NS_DM_Client::Serialize(DevInfoFieldPath[e_Man] + DevInfoFieldName[e_Man], m_Man, treeManager);
        res &= NS_DM_Client::Serialize(DevInfoFieldPath[e_Mod] + DevInfoFieldName[e_Mod], m_Mod, treeManager);
        res &= NS_DM_Client::Serialize(DevInfoFieldPath[e_DmV] + DevInfoFieldName[e_DmV], m_DmV, treeManager);
        res &= NS_DM_Client::Serialize(DevInfoFieldPath[e_Lang] + DevInfoFieldName[e_Lang], m_Lang, treeManager);
        return res;
    }
    //-------------------------------------------------------------------------------------------

    bool DevInfo::Deserialize(IMOTreeManager& treeManager)
    {
        bool res = NS_DM_Client::Deserialize(DevInfoFieldPath[e_DevId] + DevInfoFieldName[e_DevId], m_DevId, treeManager);
        res &= NS_DM_Client::Deserialize(DevInfoFieldPath[e_Man] + DevInfoFieldName[e_Man], m_Man, treeManager);
        res &= NS_DM_Client::Deserialize(DevInfoFieldPath[e_Mod] + DevInfoFieldName[e_Mod], m_Mod, treeManager);
        res &= NS_DM_Client::Deserialize(DevInfoFieldPath[e_DmV] + DevInfoFieldName[e_DmV], m_DmV, treeManager);
        res &= NS_DM_Client::Deserialize(DevInfoFieldPath[e_Lang] + DevInfoFieldName[e_Lang], m_Lang, treeManager);

        return true; // for tests only
        //return res;
    }

    //-------------------------------------------------------------------------------------------

    bool DevInfo::Serialize(String& xml) const
    {
        TNDSCreator tree;
        tree.Append(DevInfoFieldPath[e_DevId], DevInfoFieldName[e_DevId], m_DevId);
        tree.Append(DevInfoFieldPath[e_Man], DevInfoFieldName[e_Man], m_Man);
        tree.Append(DevInfoFieldPath[e_Mod], DevInfoFieldName[e_Mod], m_Mod);
        tree.Append(DevInfoFieldPath[e_DmV], DevInfoFieldName[e_DmV], m_DmV);
        tree.Append(DevInfoFieldPath[e_Lang], DevInfoFieldName[e_Lang], m_Lang);

        tree.Get(xml);
        return true;
    }
    //-------------------------------------------------------------------------------------------

    bool DevInfo::Deserialize(const String& xml)
    {
        TNDSExtractor extractor(xml);
        extractor.GetValue(DevInfoFieldName[e_DevId], m_DevId);
        extractor.GetValue(DevInfoFieldName[e_Man], m_Man);
        extractor.GetValue(DevInfoFieldName[e_Mod], m_Mod);
        extractor.GetValue(DevInfoFieldName[e_DmV], m_DmV);
        extractor.GetValue(DevInfoFieldName[e_Lang], m_Lang);

        return true;
    }


}
