#include "Common.h"
#include "Utils.h"
#include <syncml/formatter/Formatter.h>
#include <syncml/core/ObjectDel.h>
#include <base/util/XMLProcessor.h>
#include "treemanager/IMOTreeManager.h"
#include <syncml/core/Item.h>

namespace NS_DM_Client
{
    bool SerializeItemToTree(const String& path, const String& data, IMOTreeManager& treeManager, 
        const String& format, const String& acl, const String& nodeType)
    {
        // TODO: set property ACL to current node
        Funambol::Item item;
        Funambol::Target target(path.c_str());
        item.setTarget(&target);
        Funambol::Meta meta;
        if (!nodeType.empty())
            meta.setType(nodeType.c_str());

        if (!format.empty())
        {
            meta.setFormat(format.c_str());
        }
        else
        {
            const String defaultFormat("chr");
            meta.setFormat(defaultFormat.c_str());
        }

        item.setMeta(&meta);
        Funambol::ComplexData complexData(data.c_str());
        item.setData(&complexData);

        StatusCode status = treeManager.Add(path, item, 0, false);
        if (e_AlreadyExists == status)
        {
            status = treeManager.Replace(path, item, 0, false);
        }
        if (!acl.empty())
        {
            treeManager.SetPropertyValue(path, "ACL", acl);
        }
        return status == e_Ok? true: false;
    }
    //-------------------------------------------------------------------------------------------
}
