#include <boost/test/unit_test.hpp>

#include "ManagementObjects/TNDSMgmtTree/TNDSExtractor.h"
#include "TestCommon.h"
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"
#include "../../../../treemanager/UTestMOTree/MockDataStorage.h"

namespace fs = boost::filesystem;

BOOST_AUTO_TEST_CASE(TestSerializationPlainTNDSToTree)
{
	std::string tndsPlain(
		"<MgmtTree xmlns='syncml:dmddf1.2'>"
		"<VerDTD>1.2</VerDTD>\n"
		"<Node>"
		"<NodeName>MaxDepth</NodeName>\n"
		"<Path>./DevDetail/URI/</Path>\n"
		"<RTProperties>"
		"<Value>0</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>DevTyp</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Value>DevTyp</Value>\n"
		"</RTProperties>"
		"</Node>"

		"<Node>"
		"<NodeName>SwV</NodeName>\n"
		"<Path>./DevDetail/</Path>\n"
		"<RTProperties>"
		"<Value>SwV</Value>\n"
		"</RTProperties>"
		"</Node>"

		"</MgmtTree>"
		); 
	NS_DM_Client::TNDSExtractor extractor(tndsPlain);
	BOOST_CHECK(extractor.SerializeToTree(*S_treeManager));

 	fs::path path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/DevDetail/DevTyp", fs::native);
 	BOOST_CHECK(fs::exists(path));
 	path = fs::path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/DevDetail/URI/MaxDepth", fs::native);
 	BOOST_CHECK(fs::exists(path));
 	path = fs::path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/DevDetail/SwV", fs::native);
 	BOOST_CHECK(fs::exists(path));

	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
