#include "TestCommon.h"

#include <boost/test/unit_test.hpp>
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

#include "../../treemanager/UTestMOTree/MockDataStorage.h"
#include "ManagementObjects/DMAcc.h"

namespace fs = boost::filesystem;
using namespace NS_DM_Client;

void FillInDMAcc(DMAcc& dmAcc)
{
	DMAccImpl dmAccImpl;
	dmAccImpl.m_AppID = "AppID";
	dmAccImpl.m_ServerID = "ServerID";
	dmAccImpl.m_Name = "Name";
	dmAccImpl.m_PrefConRef = "PrefConRef";
	dmAccImpl.m_ToConRef.push_back("ToConRef");
	dmAccImpl.m_AAuthPref = "AAuthPref";

	dmAcc.m_DMAccImpl.push_back(dmAccImpl);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeDMAccFromTree)
{
	NS_DM_Client::DMAcc originalDmAcc;
	FillInDMAcc(originalDmAcc);
	BOOST_CHECK(originalDmAcc.Serialize(*S_treeManager));

	NS_DM_Client::DMAcc newDMAcc;
	BOOST_CHECK(newDMAcc.Deserialize(*S_treeManager));
	BOOST_CHECK(newDMAcc.m_DMAccImpl[0].m_AAuthPref == "AAuthPref");
	BOOST_CHECK(newDMAcc.m_DMAccImpl[0].m_ToConRef[0] == "ToConRef");

	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeDMAccountInTree)
{
	NS_DM_Client::DMAcc dmAccount;
	FillInDMAcc(dmAccount);

	BOOST_CHECK(dmAccount.Serialize(*S_treeManager));

	fs::path path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/DMAcc/0/AppID", fs::native);
	BOOST_CHECK(fs::exists(path));
	path = fs::path(NS_DM_Client::NS_DataStorage::S_workingDirectory + "/DMAcc/0/Name", fs::native);
	BOOST_CHECK(fs::exists(path));
	fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SerializeDMAccInXml)
{
	NS_DM_Client::DMAcc dmAcc;
	FillInDMAcc(dmAcc);

	String dmAccXml;
	BOOST_CHECK(dmAcc.Serialize(dmAccXml));

	std::string expectedDMAcc;
	ReadFromFile("SerializeDMAccInXml.xml", expectedDMAcc);

	//std::cout << dmAccXml << std::endl << std::endl;
//	BOOST_CHECK(dmAccXml == expectedDMAcc);
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(DeserializeDMAccFromXml)
{
	std::string dmAccXml;
	ReadFromFile("SerializeDMAccInXml.xml", dmAccXml);

	String data(dmAccXml.c_str());
	NS_DM_Client::DMAcc dmAcc;
	BOOST_CHECK(dmAcc.Deserialize(data));
//	BOOST_CHECK(dmAcc.m_DMAccImpl[0].m_AAuthPref == "AAuthPref");
//	BOOST_CHECK(dmAcc.m_DMAccImpl[0].m_ToConRef[0] == "ToConRef");
//	BOOST_CHECK(dmAcc.m_DMAccImpl[0].m_AppID == "AppID");
//	BOOST_CHECK(dmAcc.m_DMAccImpl[0].m_ServerID == "ServerID");
//	BOOST_CHECK(dmAcc.m_DMAccImpl[0].m_Name == "Name");
}
//-------------------------------------------------------------------------------------------
