#include "daemon/NotificationCenter.h"
#include "lock.h"
#include "Logger/LoggerMacroses.h"

extern const char* c_LogName;

namespace NS_DM_Client
{
    using namespace NS_Common;

    NotificationCenter::NotificationCenter()
    {
        Lock guard(m_notifsGuard);
    }
    //-------------------------------------------------------------------------------------------

    NotificationCenter::~NotificationCenter()
    {
        Lock guard(m_notifsGuard);
    }
    //-------------------------------------------------------------------------------------------

    bool NotificationCenter::exists(INotification* notif)
    {
        Notifications::iterator iExist = m_notifs.find(notif);
        return (iExist != m_notifs.end());
    }
    //-------------------------------------------------------------------------------------------

    bool NotificationCenter::Subscribe(INotification* notif)
    {
GDLINFO("Enter");

        Lock guard(m_notifsGuard);

        bool brc = false;
        if (notif && !exists(notif))
        {
            m_notifs[notif] = notif;
            brc = exists(notif);
        }

        return brc;
    }
    //-------------------------------------------------------------------------------------------

    bool NotificationCenter::Unsubscribe(INotification* notif)
    {
GDLINFO("Enter");

        Lock guard(m_notifsGuard);

        bool brc = false;
        if (notif)
        {
            Notifications::iterator iExist = m_notifs.find(notif);
            if (iExist != m_notifs.end())
            {
                m_notifs.erase(iExist);
                brc = !exists(notif);
            }
        }

        return brc;
    }
    //-------------------------------------------------------------------------------------------

    void NotificationCenter::NotifyDMSessionStatus(EventType eventType, Initiator initiator, NotificationStatus statusCode)
    {
GDLINFO("Enter");

        Lock guard(m_notifsGuard);

        for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end(); i != iend; ++i)
        {
            i->second->NotifyDMSessionStatus(eventType, initiator, statusCode);
        }
    }
    //-------------------------------------------------------------------------------------------

    void NotificationCenter::CheckFirmwareUpdateStatus(bool isNewFirmware)
    {
GDLINFO("Enter");

        Lock guard(m_notifsGuard);

        for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
            i != iend; ++i)
        {
            i->second->CheckFirmwareUpdateStatus(isNewFirmware);
        }
    }
    //-------------------------------------------------------------------------------------------
    
    void NotificationCenter::StartDMSessionStatus(bool started)
    {
GDLINFO("Enter");

        Lock guard(m_notifsGuard);

        for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
            i != iend; ++i)
        {
            i->second->StartDMSessionStatus(started);
        }
    }
    //-------------------------------------------------------------------------------------------
    
    void NotificationCenter::FirmwareInfo(const String &localpath, const String &filename, const int size)
    {
GDLINFO("Enter");

        Lock guard(m_notifsGuard);

        for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end(); i != iend; ++i)
        {
            i->second->FirmwareInfo(localpath, filename, size);
        }
    }
    //-------------------------------------------------------------------------------------------

    void NotificationCenter::FirmwareUpdateStart(FirmwareUpdate::EnumFirmwareOperation fwo)
    {
GDLINFO("Enter");

        Lock guard(m_notifsGuard);

        for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
            i != iend; ++i)
        {
            i->second->FirmwareUpdateStart(fwo);
        }
    }
    //-------------------------------------------------------------------------------------------

    void NotificationCenter::FirmwareUpdateFinished(FirmwareUpdate::EnumFirmwareOperation fwo)
    {
GDLINFO("Enter");

        Lock guard(m_notifsGuard);

        for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
            i != iend; ++i)
        {
            i->second->FirmwareUpdateFinished(fwo);
        }
    }
    //-------------------------------------------------------------------------------------------
    
    void NotificationCenter::StartDRMDCollecting(int duration)
    {
GDLINFO("Enter");

        Lock guard(m_notifsGuard);

        for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
            i != iend; ++i)
        {
            i->second->StartDRMDCollecting(duration);
        }
    }
    //-------------------------------------------------------------------------------------------

    void NotificationCenter::ProvisioningUpdate(const StringArray& URIs, CommandType command, EventType eventType, StatusCode resultCode)
    {
GDLINFO("Enter");

        Lock guard(m_notifsGuard);

        for(Notifications::iterator i = m_notifs.begin(), iend = m_notifs.end();
            i != iend; ++i)
        {
            i->second->ProvisioningUpdate(URIs, command, eventType, resultCode);
        }
    }
}
