/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "daemon/ProfileComponentsHolder.h"
#include "DataStorage/IDataStorage.h"
#include "treemanager/IMOTreeManager.h"
#include "serverexchange/IServerExchangeManager.h"
#include "executionqueue/IExecutionQueue.h"
#include "DeviceAdapter/IDeviceAdapter.h"
#include "NotificationListener/INotificationListener.h"
#include "daemon/INotificationCenter.h"
#include "daemon/IDaemonEngineRequest.h"
#include "daemon/Profile.h"


// Dynamic Library loading API
#include "DynamicLoader.h"

#include <cstdio>

using namespace NS_DM_Client;

template<typename _Ty>
void Release(_Ty*& o)
{
    if (o)
    {
        o->Release();
        o = NULL;
    }
}

template<typename _Ty>
void Delete(_Ty*& o)
{
    if (o)
    {
        delete o;
        o = NULL;
    }
}


ProfileComponentsHolder::ProfileComponentsHolder(const NS_Daemon::Profile& profile)
:m_ExecQueue(NULL),
m_ServExchange(NULL),
m_MOTree(NULL),
m_NotificationListener(NULL),
m_DataStorage(NULL),
m_DeviceAdapter(NULL),
m_DeviceAdapterDynamicLoader(NULL),
m_NotificationCenter(NULL),
m_daemonEngineRequest(NULL),
m_ProfileType(profile.GetType())
{
}


ProfileComponentsHolder::~ProfileComponentsHolder(void)
{
    Release(m_DataStorage);

    Delete(m_NotificationListener);
    Delete(m_ServExchange);
    Delete(m_MOTree);
    SetDeviceAdapter(NULL);
    Delete(m_ExecQueue);

    SetNotificationCenter(NULL);
    // TODO !!! Delete objects
}


IExecutionQueue* ProfileComponentsHolder::GetExecutionQueue()
{
    return m_ExecQueue;
}


IServerExchangeManager* ProfileComponentsHolder::GetServerExchangeManager()
{
    return m_ServExchange;
}


IMOTreeManager* ProfileComponentsHolder::GetMOTreeManager()
{
    return m_MOTree;
}

INotificationListener* ProfileComponentsHolder::GetNotificationListener()
{
    return m_NotificationListener;
}


IDataStorage* ProfileComponentsHolder::GetDataStorage()
{
    return m_DataStorage;
}


IDeviceAdapter* ProfileComponentsHolder::GetDeviceAdapter()
{
    return m_DeviceAdapter;
}

INotificationCenter* ProfileComponentsHolder::GetNotificationCenter()
{
    return m_NotificationCenter;
}

IDaemonEngineRequest* ProfileComponentsHolder::GetDaemonEngineRequest()
{
    return m_daemonEngineRequest;
}

const String& ProfileComponentsHolder::GetProfileType() const
{
    return m_ProfileType;
}

void ProfileComponentsHolder::SetExecutionQueue(IExecutionQueue* execq)
{
    Delete(m_ExecQueue);
    m_ExecQueue = execq;
}


void ProfileComponentsHolder::SetServerExchangeManager(IServerExchangeManager* sxm)
{
    Delete(m_ServExchange);
    m_ServExchange = sxm;
}


void ProfileComponentsHolder::SetMOTreeManager(IMOTreeManager* motm)
{
    Delete(m_MOTree);
    m_MOTree = motm;
}


void ProfileComponentsHolder::SetNotificationListener(INotificationListener* nl)
{
    Delete(m_NotificationListener);
    m_NotificationListener = nl;
}


void ProfileComponentsHolder::SetDataStorage(IDataStorage* ds)
{
    Release(m_DataStorage);
    m_DataStorage = ds;
}


void ProfileComponentsHolder::SetDeviceAdapter(IDeviceAdapter* da, DynamicLoader* dl)
{
    Release(m_DeviceAdapter);
    m_DeviceAdapter = da;

//  TODO delete liblary loader
//    Delete(m_DeviceAdapterDynamicLoader);
    m_DeviceAdapterDynamicLoader = dl;
    Delete(m_daemonEngineRequest);
}

void ProfileComponentsHolder::SetNotificationCenter(INotificationCenter* nc)
{
    Delete(m_NotificationCenter);
    m_NotificationCenter = nc;
}

void ProfileComponentsHolder::SetDaemonEngineRequest(IDaemonEngineRequest* der)
{
    Delete(m_daemonEngineRequest);
    m_daemonEngineRequest = der;
}

