/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "executionqueue/CommandQueuePool.h"
#include "executionqueue/MOTreeCommandsQueue.h"
#include "executionqueue/ServerExchangeCommandsQueue.h"

using namespace NS_DM_Client::NS_ExecutionQueue;

CommandQueuePool::CommandQueuePool(
    MOTreeCommandsQueue& MOTreeCmdQ,
    ServerExchangeCommandsQueue& ServXchgCmdQ
    )
: m_MOTreeCmdQ(MOTreeCmdQ), m_ServXchgCmdQ(ServXchgCmdQ)
{
}


CommandQueuePool::~CommandQueuePool(void)
{
    delete &m_MOTreeCmdQ;
    delete &m_ServXchgCmdQ;
}


ICommandsQueue& CommandQueuePool::GetMOTreeCmdQueue()
{
    return m_MOTreeCmdQ;
}


ICommandsQueue& CommandQueuePool::GetServerExchangeCmdQueue()
{
    return m_ServXchgCmdQ;
}

bool CommandQueuePool::StopCommandQueues()
{
    bool brc = true;

    brc &= m_MOTreeCmdQ.StopCommandExecution();
    if (!brc)
    {
        // failed to stop MOTree commands queue
    }

    brc &= m_ServXchgCmdQ.StopCommandExecution();
    if (!brc)
    {
        // failed to stop ServerExchange commands queue
    }

    return brc;
}
