/*
 *  UT_Utils.cpp
 *  OMA-DM Client
 *
 *  Created by Mykola Bilovus on 20/04/10.
 *  Copyright 2010. All rights reserved.
 *
 */


#include <boost/test/unit_test.hpp>
#include "serverexchange/session/Session.h"
#include "serverexchange/session/SessionsFactory.h"


using namespace NS_DM_Client::NS_Communication;
using namespace NS_DM_Client::NS_SyncMLCommand;


BOOST_AUTO_TEST_SUITE(SuiteSEM)


BOOST_AUTO_TEST_CASE(TestCase_Session_SendMessage)
{
	CommandStorage cmds;
	ConnectionInfo info;
	ISession *pSession;
	
	info.acconfig.setClientAuthType(AUTH_TYPE_BASIC);
	pSession = SessionsFactory::Instance().CreateSession(info);
	
	pSession->Connect(cmds);
	// check message sent to transport
	
	BOOST_CHECK(pSession);
	delete pSession;
}


BOOST_AUTO_TEST_SUITE_END()
