/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <syncml/formatter/Formatter.h>
#include "serverexchange/wrappers/SReplaceCommand.h"

using namespace NS_DM_Client::NS_SyncMLCommand;


SReplaceCommand::SReplaceCommand()
{
}


void SReplaceCommand::createItemizedCommand()
{
    m_ptrItemizedCommand.reset(new Funambol::Replace());
}


Funambol::StringBuffer * SReplaceCommand::ToString()
{
    if (m_ptrItemizedCommand.get())
        return Funambol::Formatter::getReplace(this_replace());
    else
        return SCommandAdapter::ToString();
}


Funambol::Replace * SReplaceCommand::GetReplace()
{
    return this_replace();
}
