/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "serverexchange/wrappers/SResponseCommand.h"

#include <Logger/LoggerMacroses.h>

using namespace NS_DM_Client::NS_SyncMLCommand;


SResponseCommand::SResponseCommand() : m_cmdref(NULL), m_msgref(NULL)
{
}


SResponseCommand::~SResponseCommand()
{
	SAFE_DELETE_ARR(m_cmdref);
	SAFE_DELETE_ARR(m_msgref);
}


void SResponseCommand::SetMsgRef(const char *msgref)
{
	SAFE_DELETE_ARR(m_msgref);
    m_msgref = Funambol::stringdup(msgref);
}


void SResponseCommand::SetCmdRef(const char *cmdref)
{
	SAFE_DELETE_ARR(m_cmdref);
	m_cmdref = Funambol::stringdup(cmdref);
}
