#define BOOST_TEST_MAIN

#include <iostream>
#include <boost/test/included/unit_test.hpp>
#include "Common.h"
#include "DataStorage/IDataStorage.h"
#include "common/Buffer.h"
#include "commontypes.h"
#include "daemon/Profile.h"
#include "daemon/ProfileComponentsHolder.h"

#include "MockDataStorage.h"
#include "MockDeviceAdapter.h"
#include "MockDeviceUpdater.h"

NS_DM_Client::ProfileComponentsHolder* S_ProfileHolder = 0;
NS_DM_Client::IDeviceAdapter* S_DeviceAdapter = 0;
NS_DM_Client::IDeviceUpdater* S_DeviceUpdater = 0;
NS_DM_Client::NS_DataStorage::IDataStorage* S_dataStorage = 0;
NS_DM_Client::MOTreeManager* S_treeManager = 0;

//const char* c_testProfile = "MOTreeTest_Profile";
const char* c_testProfile = "";
const char* const c_testPrivateDataPath = "/tmp/Funambol/DMClient/DataStorage";
const char* c_PrivateDataExt = ".priv";

class InitTreeManager
{
public:
	InitTreeManager()
	{
 		//_CrtSetBreakAlloc(429);
 
		S_DeviceUpdater = new NS_DM_Client::MockDeviceUpdater(); 
 		S_dataStorage = NS_DM_Client::NS_DataStorage::CreateDataStorage(c_testProfile, c_testPrivateDataPath);
 		S_treeManager = new NS_DM_Client::MOTreeManager;
 		S_DeviceAdapter = new NS_DM_Client::MockDeviceAdapter();

	        
	NS_DM_Client::NS_Daemon::Profile profile;	

	S_ProfileHolder = new NS_DM_Client::ProfileComponentsHolder(profile);
        S_ProfileHolder->SetDataStorage(S_dataStorage);
 		S_ProfileHolder->SetDeviceAdapter(S_DeviceAdapter);
 		S_ProfileHolder->SetMOTreeManager(S_treeManager);
 
        NS_DM_Client::StringMap settings;
        S_treeManager->Init(settings, "MOTreeManagerUnitTests", *S_ProfileHolder);
 		NS_DM_Client::SetDeviceUpdater(*S_treeManager, S_DeviceUpdater);
 
 		std::cout << "Setup" << std::endl;
	}

	~InitTreeManager()
	{
 		delete S_ProfileHolder;
		//delete S_DeviceUpdater;
 		std::cout << "Teardown" << std::endl;
 		String path = NS_DM_Client::NS_DataStorage::GetBasePath() + (String)"/" + c_testProfile;
        fs::remove_all(path.c_str());
	}
};

BOOST_GLOBAL_FIXTURE(InitTreeManager);
